# Aeonics Security Policy

## Reporting a Vulnerability

Please report security issues by sending an email to [our security team](mailto:contact@aeonics.io).

## Supported Versions

Security updates will be applied to the most recent version of the framework. 
Previous versions will receive updates similar to the Linux backport method, 
where critical security patches are backported to stable versions when feasible.

## Security Practices and Policies

Our framework follows a proactive approach to security and encourages the 
responsible reporting of any issues you encounter. Here are some general 
security policies for our framework:

- **Vulnerability Disclosure**: Upon receipt of a vulnerability report, 
our team will confirm the issue, assess its impact, and work on an appropriate 
fix. Information about vulnerabilities will be disclosed publicly only after a 
fix is in place, typically through a security patch or a new release, or as
required by law.

- **Security Updates**: Critical patches will be released as soon as they are 
available. Non-critical updates may be included in scheduled releases.

## Software Bill of Materials (SBOM)

This SBOM is maintained manually and updated as necessary. It outlines the 
dependencies and libraries used in the development of this framework, helping 
users understand potential security implications.

### Dependencies

- Java Runtime Environment 11+
- Compatible Operating System
- Any dependency introduced by a plugin is part of the explicit plugin definition

---

This security policy is subject to updates and modifications as necessary to 
address new security challenges and improve our response to vulnerabilities.