/*
 * Decompiled with CFR 0.152.
 */
package local;

import aeonics.Plugin;
import aeonics.data.Data;
import aeonics.entity.Console;
import aeonics.entity.Entity;
import aeonics.entity.Flow;
import aeonics.entity.Probe;
import aeonics.entity.Registry;
import aeonics.entity.Step;
import aeonics.entity.security.Group;
import aeonics.entity.security.Multifactor;
import aeonics.entity.security.Policy;
import aeonics.entity.security.Provider;
import aeonics.entity.security.Role;
import aeonics.entity.security.Rule;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Executor;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Monitor;
import aeonics.manager.Network;
import aeonics.manager.Scheduler;
import aeonics.manager.Security;
import aeonics.manager.Snapshot;
import aeonics.manager.Timeout;
import aeonics.manager.Translator;
import aeonics.manager.Vault;
import aeonics.manager.impl.DefaultConfig;
import aeonics.manager.impl.DefaultExecutor;
import aeonics.manager.impl.DefaultLifecycle;
import aeonics.manager.impl.DefaultLogger;
import aeonics.manager.impl.DefaultMonitor;
import aeonics.manager.impl.DefaultNetwork;
import aeonics.manager.impl.DefaultScheduler;
import aeonics.manager.impl.DefaultSecurity;
import aeonics.manager.impl.DefaultSnapshot;
import aeonics.manager.impl.DefaultTimeout;
import aeonics.manager.impl.DefaultTranslator;
import aeonics.manager.impl.DefaultVault;
import aeonics.template.Factory;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.util.Hardware;
import aeonics.util.Snapshotable;
import java.util.Map;

public class Main
extends Plugin {
    private String adminHash = System.getProperty("AEONICS_SECURITY_ADMIN_HASH");
    private String adminSalt = null;
    private String vaultSalt = null;
    private String adminMfa = null;

    public Main() {
        if (this.adminHash == null || this.adminHash.isBlank()) {
            this.adminHash = System.getenv("AEONICS_SECURITY_ADMIN_HASH");
        }
        if (this.adminHash == null || this.adminHash.isBlank()) {
            this.adminHash = null;
        } else {
            System.clearProperty("AEONICS_SECURITY_ADMIN_HASH");
        }
        this.adminSalt = System.getProperty("AEONICS_SECURITY_ADMIN_SALT");
        if (this.adminSalt == null || this.adminSalt.isBlank()) {
            this.adminSalt = System.getenv("AEONICS_SECURITY_ADMIN_SALT");
        }
        if (this.adminSalt == null || this.adminSalt.isBlank()) {
            this.adminSalt = null;
        } else {
            System.clearProperty("AEONICS_SECURITY_ADMIN_SALT");
        }
        this.vaultSalt = System.getProperty("AEONICS_SECURITY_VAULT_SALT");
        if (this.vaultSalt == null || this.vaultSalt.isBlank()) {
            this.vaultSalt = System.getenv("AEONICS_SECURITY_VAULT_SALT");
        }
        if (this.vaultSalt == null || this.vaultSalt.isBlank()) {
            this.vaultSalt = null;
        } else {
            System.clearProperty("AEONICS_SECURITY_VAULT_SALT");
        }
        this.adminMfa = System.getProperty("AEONICS_SECURITY_ADMIN_MFA");
        if (this.adminMfa == null || this.adminMfa.isBlank()) {
            this.adminMfa = System.getenv("AEONICS_SECURITY_ADMIN_MFA");
        }
        if (this.adminMfa == null || this.adminMfa.isBlank()) {
            this.adminMfa = null;
        } else {
            System.clearProperty("AEONICS_SECURITY_ADMIN_MFA");
        }
    }

    public String summary() {
        return "Default System";
    }

    public String description() {
        return "Initializes the default managers, security settings, sets the default factory for built-in types and loads the initial snapshot if necessary.";
    }

    private <T extends Manager.Type> void manager(Class<T> clazz, Class<? extends Manager<T>> clazz2, boolean bl, Data data) {
        if (Manager.of(clazz) == null) {
            try {
                Manager.Type type = (Manager.Type)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]).template().create(Data.map().put("parameters", (Object)data));
                type.name(clazz.getSimpleName() + " Manager");
                Manager.set(clazz, (Manager.Type)type);
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).severe(Main.class, (Throwable)exception);
                throw new RuntimeException("Manager creation failed");
            }
        } else {
            ((Logger)Manager.of(Logger.class)).fine(Main.class, "Manager instance of {} already set", new Object[]{clazz});
            if (bl) {
                throw new IllegalStateException("Manager instance already set");
            }
        }
    }

    public void start() {
        if (Manager.of(Lifecycle.class) == Lifecycle.NOOP) {
            Lifecycle lifecycle = (Lifecycle)((Lifecycle)new DefaultLifecycle().template().create()).name("Lifecycle Manager");
            Manager.replace(Lifecycle.class, (Manager.Type)lifecycle);
        }
        this.beforeBeforeLoad();
        Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.LOAD, this::beforeLoad);
        Lifecycle.on((Lifecycle.Phase)Lifecycle.Phase.LOAD, this::onLoad);
        Lifecycle.after((Lifecycle.Phase)Lifecycle.Phase.LOAD, this::afterLoad);
        Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.CONFIG, this::beforeConfig);
        Lifecycle.on((Lifecycle.Phase)Lifecycle.Phase.CONFIG, this::onConfig);
        Lifecycle.after((Lifecycle.Phase)Lifecycle.Phase.CONFIG, this::afterConfig);
        Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.RUN, this::beforeRun);
        Lifecycle.on((Lifecycle.Phase)Lifecycle.Phase.RUN, this::onRun);
        Lifecycle.after((Lifecycle.Phase)Lifecycle.Phase.RUN, this::afterRun);
        Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.SHUTDOWN, this::beforeShutdown);
        Lifecycle.on((Lifecycle.Phase)Lifecycle.Phase.SHUTDOWN, this::onShutdown);
        Lifecycle.after((Lifecycle.Phase)Lifecycle.Phase.SHUTDOWN, this::afterShutdown);
        Snapshot.onSnapshot(this::onSnapshot);
        Snapshot.onRestore(this::onRestore);
    }

    private void beforeBeforeLoad() {
        Factory.add((Item)new Console());
        this.manager(Config.class, DefaultConfig.class, false, null);
        if (Manager.of(Executor.class) == Executor.SYNCHRONOUS) {
            Executor executor = (Executor)((Executor)new DefaultExecutor().template().create()).name("Executor Manager");
            Manager.replace(Executor.class, (Manager.Type)executor);
        }
    }

    private void beforeLoad() {
    }

    private void onLoad() {
        this.manager(Snapshot.class, DefaultSnapshot.class, false, null);
        this.manager(Security.class, DefaultSecurity.class, false, null);
        this.manager(Vault.class, DefaultVault.class, false, Data.map().put("salt", (Object)this.vaultSalt));
        this.manager(Monitor.class, DefaultMonitor.class, false, null);
        this.manager(Scheduler.class, DefaultScheduler.class, false, null);
        this.manager(Timeout.class, DefaultTimeout.class, false, null);
        this.manager(Network.class, DefaultNetwork.class, false, null);
        this.manager(Translator.class, DefaultTranslator.class, false, null);
        DefaultLogger.register();
        this.vaultSalt = null;
        Config config = (Config)Manager.of(Config.class);
        config.declare(Network.class, new Parameter("backlog").summary("Socket Backlog").description("The maximum number of pending connections to be accepted by listenning server sockets.").format("number").rule(Parameter.Rule.DIGIT).optional(true).min(1).max(5).defaultValue((Object)65535));
        config.declare("aeonics.setup", new Parameter("initialized").summary("Default setup has been initialized").description("This parameter defines if the default setup has already been initialized (true) or if it should done when starting the config phase (false). This is normally set by the system to detect an initial snapshot.").format("boolean").rule(Parameter.Rule.BOOLEAN).optional(true).defaultValue((Object)false));
        config.declare("aeonics.manager.snapshot", new Parameter("current").summary("Snapshot currently loaded").description("This read-only parameter contains the name of the last restored snapshot. If set at boot time using command line parameters or environment variables, it defines which snapshot to load initially.").format("text").optional(true).defaultValue(null));
        config.declare(Provider.Local.class, new Parameter("name").summary("Default Local Provider Name").description("The display name of the default local provider for authentication.").format("text").optional(true).defaultValue((Object)"Username / Password"));
    }

    private void afterLoad() {
    }

    private void beforeConfig() {
        String string = System.getProperty("AEONICS_MANAGER_SNAPSHOT_CURRENT");
        if (string == null || string.isBlank()) {
            string = System.getenv("AEONICS_MANAGER_SNAPSHOT_CURRENT");
        }
        if (string == null || string.isBlank()) {
            string = ((Snapshot)Manager.of(Snapshot.class)).latest();
        }
        if (string != null) {
            try {
                ((Snapshot)Manager.of(Snapshot.class)).restore(string).await();
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Snapshot.class, (Throwable)exception);
            }
        } else {
            ((Logger)Manager.of(Logger.class)).fine(Snapshot.class, (Object)"No snapshot to restore");
        }
    }

    private void onConfig() {
        if (!((Config)Manager.of(Config.class)).get("aeonics.setup", "initialized").asBool()) {
            this.setupLoggerFlow();
            this.setupMonitorFlow();
            ((Config)Manager.of(Config.class)).set(Monitor.class, "enabled", (Object)true);
            ((Config)Manager.of(Config.class)).set("aeonics.setup", "initialized", (Object)true);
        }
        ((Probe.Type)new Probe(){}.template().summary("Hardware").description("This probe returns the hardware CPU and RAM metrics.").create()).source(() -> Hardware.export()).name("hardware");
    }

    private void afterConfig() {
    }

    private void beforeRun() {
        Logger logger;
        if (Manager.of(Logger.class) == Logger.CONSOLE) {
            logger = (Logger)new DefaultLogger().template().create();
            logger.name("Logger Manager");
            Manager.replace(Logger.class, (Manager.Type)logger);
        }
        if (!Registry.of(Provider.class).iterator().hasNext()) {
            Provider.Type type;
            String string;
            ((Logger)Manager.of(Logger.class)).config(Security.class, (Object)"Setting default security settings");
            logger = (User.Type)((User.Type)new User().template().create(Data.map().put("parameters", (Object)Data.map().put("login", (Object)"admin").put("active", (Object)true)))).name("Admin User").addRelation("roles", (Entity)Role.SUPERADMIN).addRelation("groups", (Entity)Group.ADMINISTRATORS).cast();
            Multifactor.Type type2 = (Multifactor.Type)((Multifactor.Type)new Multifactor.TOTP().template().create()).name("Time-based one-time password").addRelation("roles", (Entity)Role.SUPERADMIN).addRelation("groups", (Entity)Group.ADMINISTRATORS).cast();
            if (this.adminHash == null || this.adminSalt == null) {
                string = ((Security)Manager.of(Security.class)).randomHash();
                this.adminSalt = ((Security)Manager.of(Security.class)).randomHash();
                this.adminHash = ((Security)Manager.of(Security.class)).hash(string, this.adminSalt);
                System.out.println("****** CAUTION ******");
                System.out.println("No default admin user hash/salt were provided. A new password was generated:");
                System.out.println("\t" + string);
                System.out.println("To reuse this password without snapshot, use these command line arguments:");
                System.out.println("\t-DAEONICS_SECURITY_ADMIN_HASH=" + this.adminHash + " -DAEONICS_SECURITY_ADMIN_SALT=" + this.adminSalt);
            }
            string = Data.map().put("username", (Object)logger.id()).put("hash", (Object)this.adminHash).put("salt", (Object)this.adminSalt);
            this.adminHash = null;
            this.adminSalt = null;
            if (this.adminMfa != null) {
                type2.enroll((User.Type)logger, Data.map().put("secret", (Object)Multifactor.TOTP.Type.secret((String)this.adminMfa)));
                this.adminMfa = null;
            }
            if ((type = (Provider.Type)((Provider.Type)new Provider.Local().template().create()).name(((Config)Manager.of(Config.class)).get(Provider.Local.class, "name").asString())).join((Data)string, (User.Type)logger) != logger) {
                ((Logger)Manager.of(Logger.class)).severe(Security.class, (Object)"Default user could not join local provider");
            }
            ((Policy.Allow.Type)new Policy.Allow().template().create(Data.map().put("parameters", (Object)Data.map().put("scope", (Object)"topic")))).name("Allow everyone to use any topic").addRelation("rule", ((Rule.MatchAll.Type)new Rule.MatchAll().template().create()).name("Match all")).cast();
        }
    }

    private void onRun() {
        Registry.of(Step.class).forEach(type -> {
            if (type instanceof Step.Origin.Type) {
                try {
                    if (((Step.Origin.Type)type).stopped()) {
                        ((Step.Origin.Type)type).start();
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).warning(type.getClass(), (Throwable)exception);
                }
            }
        });
    }

    private void afterRun() {
    }

    private void beforeShutdown() {
    }

    private void onShutdown() {
    }

    private void afterShutdown() {
        Manager.replace(Logger.class, (Manager.Type)Logger.CONSOLE);
        Registry.of(Step.class).forEach(type -> {
            if (type instanceof Step.Origin.Type) {
                try {
                    if (((Step.Origin.Type)type).started()) {
                        ((Step.Origin.Type)type).stop();
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).warning(type.getClass(), (Throwable)exception);
                }
            }
        });
    }

    private void onSnapshot(Data data) {
        if (data == null || !data.isMap()) {
            return;
        }
        Data data2 = Data.list();
        ((Config)Manager.of(Config.class)).all().entrySet().forEach(entry2 -> {
            String string = (String)entry2.getKey();
            ((Map)entry2.getValue()).entrySet().forEach(entry -> {
                String string2 = (String)entry.getKey();
                Parameter parameter = ((Config)Manager.of(Config.class)).definition(string, string2);
                data2.add((Object)Data.map().put("name", (Object)Config.implodeName((String)string, (String)((String)entry.getKey()))).put("value", entry.getValue()).put("summary", (Object)parameter.summary()).put("description", (Object)parameter.description()));
            });
        });
        data.put("config", (Object)data2);
        Data data3 = Data.map();
        Registry.all().forEach(registry -> {
            Data data2 = Data.list();
            registry.forEach(entity -> {
                if (entity.snapshotMode() == Snapshotable.SnapshotMode.NONE) {
                    return;
                }
                data2.add((Object)entity.snapshot());
            });
            if (data2.size() > 0) {
                data3.put(registry.category(), (Object)data2);
            }
        });
        data.put("registry", (Object)data3);
    }

    private void onRestore(Data data2) {
        if (data2 == null || !data2.isMap()) {
            return;
        }
        if (!data2.isEmpty("config")) {
            Config config = (Config)Manager.of(Config.class);
            data2.get("config").forEach(data -> {
                try {
                    config.set(data.asString("name"), (Object)data.get("value"));
                    config.definition(data.asString("name")).description(data.asString("description")).summary(data.asString("summary"));
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).config(Snapshot.class, (Throwable)exception);
                }
            });
        }
        if (!data2.isEmpty("registry")) {
            Registry.all().forEach(registry -> registry.clear(entity -> !entity.internal() && entity.snapshotMode() == Snapshotable.SnapshotMode.FULL));
            data2.get("registry").entrySet().forEach(entry -> ((Data)entry.getValue()).forEach(data -> {
                try {
                    Snapshotable.SnapshotMode snapshotMode = Snapshotable.SnapshotMode.valueOf((String)data.asString("mode"));
                    Entity entity = Registry.of((String)data.asString("category")).get(data.asString("id"));
                    switch (snapshotMode) {
                        case FULL: {
                            if (entity != null) {
                                throw new IllegalStateException("Cannot overwrite target entity " + data);
                            }
                            Factory.create((Data)data);
                            break;
                        }
                        case UPDATE: {
                            if (entity == null) {
                                throw new IllegalStateException("Missing target entity " + data);
                            }
                            if (entity.snapshotMode() != Snapshotable.SnapshotMode.UPDATE) {
                                throw new IllegalStateException("Snapshot mode mismatch for entity " + data);
                            }
                            entity.template().update(data, entity);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    ((Logger)Manager.of(Logger.class)).config(Snapshot.class, (Throwable)exception);
                    return;
                }
            }));
        }
    }

    private void setupLoggerFlow() {
        Step.Destination.Type type = (Step.Destination.Type)((Step.Type)Factory.of(Step.class).get(Console.class).create()).name("Console output");
        DefaultLogger.origin().link("data", (Step.Type)type, "data");
        ((Flow.Type)Factory.of(Flow.class).get(Flow.class).create()).step((Step.Type)DefaultLogger.origin(), 1, 1).step((Step.Type)type, 3, 3).name("Logs").parameter("notes", (Object)"This data flow is used to manage the system logs.");
    }

    private void setupMonitorFlow() {
        ((Flow.Type)Factory.of(Flow.class).get(Flow.class).create()).step((Step.Type)DefaultMonitor.origin(), 1, 1).name("Monitoring").parameter("notes", (Object)"This data flow is used to manage the various metrics of the system.");
    }
}

