/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.manager.Snapshot;
import aeonics.manager.Vault;
import aeonics.template.Template;
import aeonics.util.CheckCaller;
import aeonics.util.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class DefaultVault
extends Manager<Vault> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Vault> template() {
        return super.template().summary("Simple vault").description("This vault implementation stores data in memory and offers class instance access protection.").onCreate((data2, vault) -> {
            if (data2.containsKey("salt")) {
                ((Implementation)vault).salt = data2.asString("salt");
            }
            Snapshot.onRestore(data -> {
                if (!(Manager.of(Vault.class) instanceof Implementation)) {
                    return;
                }
                if (data == null || !data.isMap() || !data.isMap("vault") || data.isEmpty("vault")) {
                    return;
                }
                Implementation implementation = (Implementation)Manager.of(Vault.class);
                implementation.store.clear();
                data.get("vault").entrySet().forEach(entry -> implementation.store.put((String)entry.getKey(), ((Data)entry.getValue()).asString()));
            });
            Snapshot.onSnapshot(data -> {
                if (!(Manager.of(Vault.class) instanceof Implementation)) {
                    return;
                }
                if (data == null || !data.isMap()) {
                    return;
                }
                Data data2 = Data.map();
                Implementation implementation = (Implementation)Manager.of(Vault.class);
                implementation.store.entrySet().forEach(entry -> data2.put((String)entry.getKey(), entry.getValue()));
                data.put("vault", (Object)data2);
            });
        });
    }

    private static class Implementation
    extends Vault {
        private String salt = null;
        private Map<String, String> store = new HashMap<String, String>();

        private Implementation() {
        }

        private String obfuscate(String string) {
            if (this.salt == null || string == null) {
                return string;
            }
            return ((Security)Manager.of(Security.class)).hash(string, this.salt);
        }

        public Data get(String string, String string2) throws SecurityException {
            Objects.requireNonNull(string);
            if (string.length() > 0 && string.charAt(0) == '#') {
                try {
                    CheckCaller.require(((Object)((Object)this)).getClass(), (String)"get", (int)0, (boolean)true);
                }
                catch (IllegalCallerException illegalCallerException) {
                    throw new SecurityException("Name reserved for owning entity.");
                }
            }
            if (string2 == null) {
                string2 = ((Security)Manager.of(Security.class)).hash(string2);
            }
            string = this.obfuscate(string);
            string2 = this.obfuscate(string2);
            String string3 = this.store.get(string);
            if (string3 == null) {
                return Data.empty();
            }
            return Json.decode((String)((Security)Manager.of(Security.class)).decrypt(string3, string2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string, Data data, String string2) throws SecurityException {
            Objects.requireNonNull(string);
            if (string.length() > 0 && string.charAt(0) == '#') {
                try {
                    CheckCaller.require(((Object)((Object)this)).getClass(), (String)"set", (int)0, (boolean)true);
                }
                catch (IllegalCallerException illegalCallerException) {
                    throw new SecurityException("Name reserved for owning entity.");
                }
            }
            if (string2 == null) {
                string2 = ((Security)Manager.of(Security.class)).hash(string2);
            }
            if (data == null) {
                data = Data.empty();
            }
            string = this.obfuscate(string);
            string2 = this.obfuscate(string2);
            String string3 = this.store.get(string);
            if (string3 != null) {
                ((Security)Manager.of(Security.class)).decrypt(string3, string2);
            }
            Map<String, String> map = this.store;
            synchronized (map) {
                this.store.put(string, ((Security)Manager.of(Security.class)).encrypt(data.asString(), string2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String string, String string2) throws SecurityException {
            Objects.requireNonNull(string);
            if (string.length() > 0 && string.charAt(0) == '#') {
                try {
                    CheckCaller.require(((Object)((Object)this)).getClass(), (String)"remove", (int)0, (boolean)true);
                }
                catch (IllegalCallerException illegalCallerException) {
                    throw new SecurityException("Name reserved for owning entity.");
                }
            }
            if (string2 == null) {
                string2 = ((Security)Manager.of(Security.class)).hash(string2);
            }
            string = this.obfuscate(string);
            string2 = this.obfuscate(string2);
            String string3 = this.store.get(string);
            if (string3 == null) {
                return;
            }
            ((Security)Manager.of(Security.class)).decrypt(string3, string2);
            Map<String, String> map = this.store;
            synchronized (map) {
                this.store.remove(string);
            }
        }

        public Data get(String string, Entity entity) throws SecurityException {
            try {
                CheckCaller.require(entity.getClass(), null, (int)0, (boolean)true);
            }
            catch (IllegalCallerException illegalCallerException) {
                throw new SecurityException("This method can only be called from the owning entity");
            }
            return this.get("#" + entity.type() + "@" + entity.id() + ":" + string, entity.id());
        }

        public void set(String string, Data data, Entity entity) throws SecurityException {
            try {
                CheckCaller.require(entity.getClass(), null, (int)0, (boolean)true);
            }
            catch (IllegalCallerException illegalCallerException) {
                throw new SecurityException("This method can only be called from the owning entity");
            }
            this.set("#" + entity.type() + "@" + entity.id() + ":" + string, data, entity.id());
        }

        public void remove(String string, Entity entity) throws SecurityException {
            try {
                CheckCaller.require(entity.getClass(), null, (int)0, (boolean)true);
            }
            catch (IllegalCallerException illegalCallerException) {
                throw new SecurityException("This method can only be called from the owning entity");
            }
            this.remove("#" + entity.type() + "@" + entity.id() + ":" + string, entity.id());
        }
    }
}

