/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Registry;
import aeonics.entity.Storage;
import aeonics.entity.security.Token;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.manager.Timeout;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Callback;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public class DefaultSecurity
extends Manager<Security> {
    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Security> template() {
        return super.template().summary("Security manager").description("Security layer that manages tokens locally. Hash functions are variable-iteration SHA-256. Encryption is performed using AES/GCM/NoPadding with an enforced key size of 265 bits.").config(Security.class, new Parameter("token.storage").summary("Token storage").description("The name or id of the storage for access tokens. If the storage does not exist, a local temporary (ouf-of-storage) location is used instead.").format("text").optional(true).defaultValue((Object)Data.empty())).onCreate((data, security) -> {
            if (((Lifecycle)Manager.of(Lifecycle.class)).phase() == Lifecycle.Phase.RUN) {
                ((Timeout)Manager.of(Timeout.class)).watch(((Implementation)security).tracker);
            } else {
                Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.RUN, (Callback.Once)Callback.once(() -> ((Timeout)Manager.of(Timeout.class)).watch(((Implementation)security).tracker)));
            }
        });
    }

    private static class Implementation
    extends Security {
        private static SecureRandom random;
        private static final int keySize = 32;
        private byte[] hexArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        private Map<String, Token> tokens = new ConcurrentHashMap<String, Token>();
        private Timeout.Tracker<Void> tracker = new Timeout.Tracker<Void>(null){
            private long next;
            {
                super((Object)void_);
                this.next = 0L;
            }

            public long delay() {
                if (this.next == 0L || this.next < System.currentTimeMillis()) {
                    this.checkNow();
                }
                return this.next - System.currentTimeMillis();
            }

            private void checkNow() {
                Long l = System.currentTimeMillis();
                AtomicLong atomicLong = new AtomicLong(300000L);
                Storage.Type type = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type == null) {
                    tokens.values().removeIf(token -> {
                        if (token == null || !token.isValid()) {
                            return true;
                        }
                        atomicLong.set(Math.min(atomicLong.get(), token.notAfter() - l));
                        return false;
                    });
                } else {
                    for (String string : type.list("token/")) {
                        Data data = type.getData(string);
                        if (data == null || data.isEmpty()) continue;
                        Token token2 = new Token(data);
                        if (!token2.isValid()) {
                            type.remove(string);
                            continue;
                        }
                        atomicLong.set(Math.min(atomicLong.get(), token2.notAfter() - l));
                    }
                }
                if (atomicLong.get() <= 0L) {
                    atomicLong.set(300000L);
                }
                this.next = l + atomicLong.get();
            }
        };

        private Implementation() {
        }

        private byte[] normalizeKey(byte[] byArray) {
            if (byArray.length == 32) {
                return byArray;
            }
            if (byArray.length < 32) {
                byte[] byArray2 = new byte[32];
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = byArray[i % byArray.length];
                }
                return byArray2;
            }
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (int i = 32; i < byArray.length; ++i) {
                int n = i % 32;
                byArray3[n] = (byte)(byArray3[n] ^ byArray[i]);
            }
            return byArray3;
        }

        public String encrypt(byte[] byArray, byte[] byArray2) {
            try {
                Objects.requireNonNull(byArray);
                Objects.requireNonNull(byArray2);
                if (byArray2.length == 0) {
                    throw new IllegalArgumentException("Invalid empty key");
                }
                byte[] byArray3 = this.normalizeKey(byArray2);
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(1, new SecretKeySpec(byArray3, "AES"));
                byte[] byArray4 = cipher.getIV();
                if (byArray4.length > 255) {
                    throw new IllegalStateException("IV length exceeds single byte limit");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray4.length);
                byteArrayOutputStream.write(byArray4);
                byteArrayOutputStream.write(cipher.doFinal(byArray));
                return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                throw new SecurityException("Encrypt failed");
            }
        }

        public String encrypt(byte[] byArray, PublicKey publicKey) {
            try {
                Objects.requireNonNull(byArray);
                Objects.requireNonNull(publicKey);
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(256, random);
                SecretKey secretKey = keyGenerator.generateKey();
                byte[] byArray2 = new byte[12];
                random.nextBytes(byArray2);
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, byArray2), random);
                Cipher cipher2 = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
                cipher2.init(1, (Key)publicKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT), random);
                byte[] byArray3 = cipher2.doFinal(secretKey.getEncoded());
                if (byArray3.length > 65535) {
                    throw new IllegalArgumentException("Key length overflow");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray3.length >>> 8 & 0xFF);
                byteArrayOutputStream.write(byArray3.length & 0xFF);
                byteArrayOutputStream.write(byArray3);
                byteArrayOutputStream.write(byArray2.length >> 8 & 0xFF);
                byteArrayOutputStream.write(byArray2.length & 0xFF);
                byteArrayOutputStream.write(byArray2);
                byteArrayOutputStream.write(cipher.doFinal(byArray));
                return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                throw new SecurityException("Encrypt failed");
            }
        }

        public byte[] decrypt(String string, byte[] byArray) {
            try {
                Objects.requireNonNull(string);
                Objects.requireNonNull(byArray);
                byte[] byArray2 = Base64.getDecoder().decode(string);
                byte[] byArray3 = this.normalizeKey(byArray);
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, Arrays.copyOfRange(byArray2, 1, byArray2[0] + 1));
                cipher.init(2, (Key)new SecretKeySpec(byArray3, "AES"), gCMParameterSpec);
                return cipher.doFinal(Arrays.copyOfRange(byArray2, byArray2[0] + 1, byArray2.length));
            }
            catch (Exception exception) {
                throw new SecurityException("Decrypt failed");
            }
        }

        public byte[] decrypt(String string, PrivateKey privateKey) {
            try {
                Objects.requireNonNull(string);
                Objects.requireNonNull(privateKey);
                byte[] byArray = Base64.getDecoder().decode(string);
                int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
                byte[] byArray2 = Arrays.copyOfRange(byArray, 2, n + 2);
                int n2 = (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
                byte[] byArray3 = Arrays.copyOfRange(byArray, n + 4, n + n2 + 4);
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
                cipher.init(2, (Key)privateKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT), random);
                byte[] byArray4 = cipher.doFinal(byArray2);
                Cipher cipher2 = Cipher.getInstance("AES/GCM/NoPadding");
                cipher2.init(2, (Key)new SecretKeySpec(byArray4, "AES"), new GCMParameterSpec(128, byArray3), random);
                int n3 = n + n2 + 4;
                byte[] byArray5 = Arrays.copyOfRange(byArray, n3, byArray.length);
                return cipher2.doFinal(byArray5);
            }
            catch (Exception exception) {
                throw new SecurityException("Decrypt failed");
            }
        }

        public boolean verify(String string, byte[] byArray, PublicKey publicKey) {
            try {
                Signature signature = Signature.getInstance("SHA256withRSA");
                signature.initVerify(publicKey);
                signature.update(byArray);
                return signature.verify(Base64.getDecoder().decode(string));
            }
            catch (Exception exception) {
                return false;
            }
        }

        public String sign(byte[] byArray, PrivateKey privateKey) {
            try {
                Signature signature = Signature.getInstance("SHA256withRSA");
                signature.initSign(privateKey);
                signature.update(byArray);
                return Base64.getEncoder().encodeToString(signature.sign());
            }
            catch (Exception exception) {
                throw new SecurityException("Signature failed");
            }
        }

        public String hash(InputStream inputStream) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                try (Object object = new DigestInputStream(inputStream, messageDigest);){
                    byte[] byArray = new byte[8192];
                    while (((FilterInputStream)object).read(byArray) != -1) {
                    }
                }
                object = messageDigest.digest();
                for (int i = 10000 + new BigInteger((byte[])object).mod(BigInteger.valueOf(10000L)).intValue(); i > 0; --i) {
                    object = messageDigest.digest((byte[])object);
                }
                return this.parseBinaryHex((byte[])object);
            }
            catch (Exception exception) {
                throw new RuntimeException("Hash failed");
            }
        }

        public String hash(byte[] byArray, byte[] byArray2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                if (byArray2 != null) {
                    messageDigest.update(byArray2);
                }
                byte[] byArray3 = messageDigest.digest(byArray);
                for (int i = 10000 + new BigInteger(byArray3).mod(BigInteger.valueOf(10000L)).intValue(); i > 0; --i) {
                    byArray3 = messageDigest.digest(byArray3);
                }
                return this.parseBinaryHex(byArray3);
            }
            catch (Exception exception) {
                throw new RuntimeException("Hash failed");
            }
        }

        public String randomHash() {
            try {
                byte[] byArray = MessageDigest.getInstance("SHA-256").digest((System.nanoTime() + "/" + random.nextLong()).getBytes());
                return this.parseBinaryHex(byArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Hash failed");
            }
        }

        private String parseBinaryHex(byte[] byArray) {
            byte[] byArray2 = new byte[byArray.length * 2];
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n = byArray[i] & 0xFF;
                byArray2[i * 2] = this.hexArray[n >>> 4];
                byArray2[i * 2 + 1] = this.hexArray[n & 0xF];
            }
            return new String(byArray2);
        }

        public synchronized Token generateToken(User.Type type, long l, boolean bl, String ... stringArray) {
            if (type == null || type == User.ANONYMOUS || type == User.SYSTEM || stringArray == null || stringArray.length == 0) {
                throw new IllegalArgumentException();
            }
            try {
                if (bl) {
                    this.clearTokens(type);
                }
                Token token = new Token(type, l, stringArray);
                Storage.Type type2 = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type2 == null) {
                    this.tokens.put(token.value(), token);
                } else {
                    type2.put("token/" + token.value(), token.export());
                }
                return token;
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Security.class, (Throwable)exception);
                return null;
            }
        }

        public synchronized Token authenticate(String string, boolean bl) {
            if (string == null || string.isBlank()) {
                return null;
            }
            try {
                Token token = null;
                Storage.Type type = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type == null) {
                    token = this.tokens.get(string);
                } else if (type.containsEntry("token/" + string)) {
                    token = new Token(type.getData("token/" + string));
                }
                if (token == null) {
                    return null;
                }
                if (!token.isValid()) {
                    if (type == null) {
                        this.tokens.remove(string);
                    } else {
                        type.remove("token/" + string);
                    }
                    return null;
                }
                if (bl) {
                    token.reset();
                    if (type != null) {
                        type.put("token/" + string, token.export());
                    }
                }
                return token;
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Security.class, (Throwable)exception);
                return null;
            }
        }

        public synchronized void revokeToken(Token token) {
            if (token == null) {
                return;
            }
            try {
                Storage.Type type = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type == null) {
                    this.tokens.remove(token.value());
                } else {
                    type.remove("token/" + token.value());
                }
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Security.class, (Throwable)exception);
            }
        }

        public synchronized void clearTokens(User.Type type) {
            if (type == null || type == User.ANONYMOUS || type == User.SYSTEM) {
                return;
            }
            try {
                String string = type.id();
                Storage.Type type2 = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type2 == null) {
                    this.tokens.values().removeIf(token -> token.isFor(string) || !token.isValid());
                } else {
                    for (String string2 : type2.list("token/")) {
                        Token token2;
                        Data data = type2.getData(string2);
                        if (data == null || data.isEmpty() || !(token2 = new Token(data)).isFor(string) && token2.isValid()) continue;
                        type2.remove(string2);
                    }
                }
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Security.class, (Throwable)exception);
            }
        }

        public synchronized Collection<Token> listTokens(User.Type type) {
            if (type == null || type == User.ANONYMOUS || type == User.SYSTEM) {
                return Collections.emptyList();
            }
            try {
                String string = type.id();
                Storage.Type type2 = (Storage.Type)Registry.of(Storage.class).get(((Config)Manager.of(Config.class)).get(Security.class, "token.storage").asString());
                if (type2 == null) {
                    return this.tokens.values().stream().filter(token -> token.isFor(string)).map(token -> new Token(token.export())).collect(Collectors.toList());
                }
                ArrayList<Token> arrayList = new ArrayList<Token>();
                for (String string2 : type2.list("token/")) {
                    Token token2;
                    Data data = type2.getData(string2);
                    if (data == null || data.isEmpty() || !(token2 = new Token(data)).isFor(string)) continue;
                    arrayList.add(token2);
                }
                return arrayList;
            }
            catch (Exception exception) {
                ((Logger)Manager.of(Logger.class)).warning(Security.class, (Throwable)exception);
                return Collections.emptyList();
            }
        }

        static {
            try {
                random = SecureRandom.getInstanceStrong();
            }
            catch (Exception exception) {
                random = null;
            }
        }
    }
}

