/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import aeonics.data.Data;
import aeonics.manager.Network;
import aeonics.util.Json;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Http {
    public static int CONNECT_TIMEOUT = 1500;

    public static SSLContext mTLS(String string, String string2, String string3) throws Exception {
        X509Certificate x509Certificate = Network.SecurityOptions.certificate(string3);
        return Network.sslContext(new Network.SecurityOptions().withClientCertificate(string, string2).withServerVerifier(x509Certificate2 -> {
            try {
                x509Certificate2.checkValidity();
                if (x509Certificate2.equals(x509Certificate)) {
                    return;
                }
                if (x509Certificate.getBasicConstraints() >= 0) {
                    boolean bl;
                    boolean[] blArray = x509Certificate.getKeyUsage();
                    boolean bl2 = bl = blArray == null || blArray.length > 5 && blArray[5];
                    if (bl) {
                        x509Certificate2.verify(x509Certificate.getPublicKey());
                        return;
                    }
                }
                throw new RuntimeException();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException();
            }
        }), true);
    }

    private static SSLSocketFactory __bugfix(final SSLSocketFactory sSLSocketFactory, String string) {
        final SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setServerNames(List.of(new SNIHostName(string)));
        return new SSLSocketFactory(){

            private Socket setSNI(Socket socket) {
                ((SSLSocket)socket).setSSLParameters(sSLParameters);
                return socket;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return sSLSocketFactory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return sSLSocketFactory.getSupportedCipherSuites();
            }

            @Override
            public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
                return this.setSNI(sSLSocketFactory.createSocket(socket, string, n, bl));
            }

            @Override
            public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
                return this.setSNI(sSLSocketFactory.createSocket(string, n));
            }

            @Override
            public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
                return this.setSNI(sSLSocketFactory.createSocket(string, n, inetAddress, n2));
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
                return this.setSNI(sSLSocketFactory.createSocket(inetAddress, n));
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
                return this.setSNI(sSLSocketFactory.createSocket(inetAddress, n, inetAddress2, n2));
            }
        };
    }

    private Http() {
    }

    public static Data post(String string) {
        return Http.post(string, null, null, "POST");
    }

    public static Data post(String string, Data data) {
        return Http.post(string, data, null, "POST");
    }

    public static Data post(String string, Data data, Data data2) {
        return Http.post(string, data, data2, "POST");
    }

    public static Data post(String string, Data data, Data data2, String string2) {
        return Http.post(string, data, data2, string2, 0);
    }

    public static Data post(String string, Data data, Data data2, String string2, int n) {
        return Http.post(string, data, data2, string2, n, null);
    }

    public static Data post(String string2, Data data, Data data2, String string3, int n, SSLContext sSLContext) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object throwable;
            block53: {
                InputStream inputStream;
                block51: {
                    block52: {
                        if (string2 == null || string2.isBlank() || !string2.startsWith("http://") && !string2.startsWith("https://")) {
                            throw new IllegalArgumentException("Invalid url");
                        }
                        if (data2 == null) {
                            data2 = Data.map();
                        }
                        if (!data2.isMap()) {
                            throw new IllegalArgumentException("Invalid headers");
                        }
                        if (data == null) {
                            data = Data.empty();
                        }
                        HttpURLConnection.setFollowRedirects(true);
                        URL uRL = URI.create(string2).toURL();
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod(string3);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setConnectTimeout(CONNECT_TIMEOUT);
                        httpURLConnection.setInstanceFollowRedirects(true);
                        if (httpURLConnection instanceof HttpsURLConnection) {
                            if (sSLContext != null) {
                                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(Http.__bugfix(sSLContext.getSocketFactory(), uRL.getHost()));
                            } else {
                                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(Http.__bugfix(Network.sslContext(null, true).getSocketFactory(), uRL.getHost()));
                            }
                            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier((string, sSLSession) -> true);
                        }
                        for (Map.Entry<String, Data> object22 : data2.entrySet()) {
                            httpURLConnection.setRequestProperty(object22.getKey(), object22.getValue().asString());
                        }
                        httpURLConnection.setRequestProperty("Connection", "close");
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        switch (data2.asString("Content-Type")) {
                            case "": {
                                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            }
                            case "application/x-www-form-urlencoded": {
                                if (data.isMap()) {
                                    for (Map.Entry<String, Data> throwable3 : data.entrySet()) {
                                        byteArrayOutputStream.write(URLEncoder.encode(throwable3.getKey(), StandardCharsets.UTF_8).replace("+", "%20").getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write(61);
                                        byteArrayOutputStream.write(URLEncoder.encode(throwable3.getValue().asString(), StandardCharsets.UTF_8).replace("+", "%20").getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write(38);
                                    }
                                    break;
                                }
                                byteArrayOutputStream.write(data.asString().getBytes(StandardCharsets.ISO_8859_1));
                                break;
                            }
                            case "multipart/form-data": {
                                httpURLConnection.setRequestProperty("Content-Type", data2.asString("Content-Type") + ";boundary=\"a-e-o-n-i-c-s\"");
                                if (data.isMap()) {
                                    for (Map.Entry<String, Data> throwable3 : data.entrySet()) {
                                        Data data3 = throwable3.getValue();
                                        if (data3.isMap() && data3.containsKey("name") && data3.containsKey("mime") && data3.containsKey("content")) {
                                            byteArrayOutputStream.write("--a-e-o-n-i-c-s\r\nContent-Disposition: form-data; name=\"".getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write(throwable3.getKey().replaceAll("[\"\\r\\n\\x00]", "").getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write("\"; filename=\"".getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write(data3.asString("name").replaceAll("[\"\\r\\n\\x00]", "").getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write("\"\r\nContent-Type: ".getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write(data3.asString("mime").replaceAll("[\"\\r\\n\\x00]", "").getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write("\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write(data3.asString("content").getBytes(StandardCharsets.ISO_8859_1));
                                            byteArrayOutputStream.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                                            continue;
                                        }
                                        byteArrayOutputStream.write("--a-e-o-n-i-c-s\r\nContent-Disposition: form-data; name=\"".getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write(throwable3.getKey().replaceAll("[\"\\r\\n\\x00]", "").getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write("\"\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write(data3.asString().getBytes(StandardCharsets.ISO_8859_1));
                                        byteArrayOutputStream.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                                    }
                                    byteArrayOutputStream.write("--a-e-o-n-i-c-s--\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
                                    break;
                                }
                                throw new IllegalArgumentException("Invalid multipart boundary");
                            }
                            default: {
                                byteArrayOutputStream.write(data.asString().getBytes(StandardCharsets.ISO_8859_1));
                            }
                        }
                        httpURLConnection.setRequestProperty("Content-Length", "" + (byteArrayOutputStream == null ? 0 : byteArrayOutputStream.size()));
                        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                            outputStream.write(byteArrayOutputStream.toByteArray());
                        }
                        int n2 = httpURLConnection.getResponseCode();
                        if (n2 < 0 || n2 >= 400) {
                            InputStream inputStream2 = httpURLConnection.getErrorStream();
                            try {
                                throw new Error(n2, inputStream2 == null ? null : new String(inputStream2.readAllBytes(), StandardCharsets.ISO_8859_1));
                            }
                            catch (Throwable throwable2) {
                                if (inputStream2 != null) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                }
                                throw throwable2;
                            }
                        }
                        inputStream = httpURLConnection.getInputStream();
                        try {
                            if (!Objects.requireNonNullElse(httpURLConnection.getContentType(), "").startsWith("application/json")) break block51;
                            throwable = Json.decode(new String(inputStream.readAllBytes(), StandardCharsets.ISO_8859_1));
                            if (inputStream == null) break block52;
                        }
                        catch (Throwable throwable4) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable4.addSuppressed(throwable5);
                                    }
                                }
                                throw throwable4;
                            }
                            catch (Error error) {
                                throw error;
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        inputStream.close();
                    }
                    return throwable;
                }
                throwable = Data.of(new String(inputStream.readAllBytes(), StandardCharsets.ISO_8859_1));
                if (inputStream == null) break block53;
                inputStream.close();
            }
            return throwable;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static Data get(String string) {
        return Http.get(string, null, null, "GET");
    }

    public static Data get(String string, Data data) {
        return Http.get(string, data, null, "GET");
    }

    public static Data get(String string, Data data, Data data2) {
        return Http.get(string, data, data2, "GET");
    }

    public static Data get(String string, Data data, Data data2, String string2) {
        return Http.get(string, data, data2, string2, 0);
    }

    public static Data get(String string, Data data, Data data2, String string2, int n) {
        return Http.get(string, data, data2, string2, n, null);
    }

    public static Data get(String string2, Data data, Data data2, String string3, int n, SSLContext sSLContext) {
        HttpURLConnection httpURLConnection = null;
        try {
            Data data3;
            block35: {
                InputStream inputStream;
                block33: {
                    Data data4;
                    block34: {
                        if (string2 == null || string2.isBlank() || !string2.startsWith("http://") && !string2.startsWith("https://")) {
                            throw new IllegalArgumentException("Invalid url");
                        }
                        if (data2 == null) {
                            data2 = Data.map();
                        }
                        if (!data2.isMap()) {
                            throw new IllegalArgumentException("Invalid headers");
                        }
                        if (data == null) {
                            data = Data.empty();
                        }
                        StringBuilder stringBuilder = null;
                        if (data.isMap()) {
                            stringBuilder = new StringBuilder();
                            for (Map.Entry<String, Data> object2 : data.entrySet()) {
                                stringBuilder.append(URLEncoder.encode(object2.getKey(), StandardCharsets.UTF_8).replace("+", "%20") + "=" + URLEncoder.encode(object2.getValue().asString(), StandardCharsets.UTF_8).replace("+", "%20") + "&");
                            }
                        } else {
                            stringBuilder = new StringBuilder(data.asString());
                        }
                        HttpURLConnection.setFollowRedirects(true);
                        URL uRL = URI.create(string2 + (string2.indexOf(63) > 0 ? "&" : "?") + stringBuilder.toString()).toURL();
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod(string3);
                        httpURLConnection.setConnectTimeout(Math.max(n, CONNECT_TIMEOUT));
                        if (n > 0) {
                            httpURLConnection.setReadTimeout(n);
                        }
                        httpURLConnection.setInstanceFollowRedirects(true);
                        if (httpURLConnection instanceof HttpsURLConnection) {
                            if (sSLContext != null) {
                                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(Http.__bugfix(sSLContext.getSocketFactory(), uRL.getHost()));
                            } else {
                                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(Http.__bugfix(Network.sslContext(null, true).getSocketFactory(), uRL.getHost()));
                            }
                            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier((string, sSLSession) -> true);
                        }
                        for (Map.Entry<String, Data> entry : data2.entrySet()) {
                            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue().asString());
                        }
                        httpURLConnection.setRequestProperty("Connection", "close");
                        int n2 = httpURLConnection.getResponseCode();
                        if (n2 < 0 || n2 >= 400) {
                            InputStream inputStream2 = httpURLConnection.getErrorStream();
                            try {
                                throw new Error(n2, inputStream2 == null ? null : new String(inputStream2.readAllBytes(), StandardCharsets.ISO_8859_1));
                            }
                            catch (Throwable throwable) {
                                if (inputStream2 != null) {
                                    try {
                                        inputStream2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        inputStream = httpURLConnection.getInputStream();
                        try {
                            if (!Objects.requireNonNullElse(httpURLConnection.getContentType(), "").startsWith("application/json")) break block33;
                            data4 = Json.decode(new String(inputStream.readAllBytes(), StandardCharsets.ISO_8859_1));
                            if (inputStream == null) break block34;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Error error) {
                                throw error;
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                        inputStream.close();
                    }
                    return data4;
                }
                data3 = Data.of(new String(inputStream.readAllBytes(), StandardCharsets.ISO_8859_1));
                if (inputStream == null) break block35;
                inputStream.close();
            }
            return data3;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static class Error
    extends IllegalStateException {
        public int code = 500;
        public String body = null;

        public Error(int n, String string) {
            this.code = n;
            this.body = string;
        }

        @Override
        public String toString() {
            return "Http error " + this.code + ": " + this.body;
        }
    }
}

