/*
 * Decompiled with CFR 0.152.
 */
package aeonics.template;

import aeonics.data.Data;
import aeonics.manager.Config;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Translator;
import aeonics.manager.Vault;
import aeonics.util.Documented;
import aeonics.util.Exportable;
import aeonics.util.Functions;
import aeonics.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parameter
implements Documented {
    private String name;
    private String summary = "";
    private String format = "text";
    private String description = "";
    private boolean bindable = true;
    private Functions.Predicate<Data> validator = data -> {
        String string = data.asString();
        if (string.length() == 0 && this.defaultValue() != null) {
            string = this.defaultValue().asString();
        }
        if (string.length() == 0 && this.optional()) {
            return true;
        }
        if (string.length() < this.min() || string.length() > this.max()) {
            return false;
        }
        if (this.values().size() > 0 && !this.values().contains(string)) {
            return false;
        }
        return this.rule() == null || this.rule().test(string);
    };
    private Data defaultValue = null;
    private static Pattern bindingPattern = Pattern.compile("\\$\\{([a-z]+):(.+?)\\}");
    private boolean optional = false;
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private Set<String> values = new HashSet<String>();
    private Functions.Predicate<String> rule = null;

    public Parameter(String string) {
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException("Parameter name is mandatory");
        }
        this.name = string;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String summary() {
        return this.summary;
    }

    public <P extends Parameter> P summary(String string) {
        this.summary = string;
        return (P)this;
    }

    public String format() {
        return this.format;
    }

    public <P extends Parameter> P format(String string) {
        this.format = string;
        return (P)this;
    }

    @Override
    public String description() {
        return this.description;
    }

    public <P extends Parameter> P description(String string) {
        this.description = string;
        return (P)this;
    }

    public boolean bindable() {
        return this.bindable;
    }

    public <P extends Parameter> P bindable(boolean bl) {
        this.bindable = bl;
        return (P)this;
    }

    public boolean validate(Data data) {
        Functions.Predicate<Data> predicate;
        if (data == null || data.isNull()) {
            data = this.defaultValue();
        }
        if (data == null) {
            data = Data.empty();
        }
        if ((predicate = this.validator()) != null) {
            try {
                return predicate.test(data);
            }
            catch (Exception exception) {
                Manager.of(Logger.class).fine(Parameter.class, (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    public Functions.Predicate<Data> validator() {
        return this.validator;
    }

    public <P extends Parameter> P validator(Functions.Predicate<Data> predicate) {
        this.validator = predicate;
        return (P)this;
    }

    public Data defaultValue() {
        return this.defaultValue;
    }

    public <P extends Parameter> P defaultValue(Object object) {
        this.defaultValue = Data.of(object);
        return (P)this;
    }

    public Data resolve(Data data, Data data2) {
        Object object;
        if (data == null || data.isEmpty()) {
            object = this.defaultValue();
            if (object == null) {
                return Data.empty();
            }
            data = object;
        }
        if (data.isEmpty() || !this.bindable() || !data.isString()) {
            return data;
        }
        object = new StringBuilder();
        Matcher matcher = bindingPattern.matcher(data.asString());
        block20: while (matcher.find()) {
            String string = matcher.group(2);
            switch (matcher.group(1)) {
                case "config": {
                    try {
                        matcher.appendReplacement((StringBuilder)object, Matcher.quoteReplacement(Objects.requireNonNullElse(Manager.of(Config.class).get(string).asString(), "")));
                    }
                    catch (Exception exception) {
                        matcher.appendReplacement((StringBuilder)object, "");
                    }
                    continue block20;
                }
                case "context": {
                    try {
                        if (data2 != null && data2.is(Exportable.class)) {
                            data2 = ((Exportable)((Object)data2)).export();
                        }
                        matcher.appendReplacement((StringBuilder)object, data2 != null ? Matcher.quoteReplacement(data2.getNested(string).asString()) : "");
                    }
                    catch (Exception exception) {
                        matcher.appendReplacement((StringBuilder)object, "");
                    }
                    continue block20;
                }
                case "secret": {
                    try {
                        matcher.appendReplacement((StringBuilder)object, Matcher.quoteReplacement(Objects.requireNonNullElse(Manager.of(Vault.class).get(string).toString(), "")));
                    }
                    catch (Exception exception) {
                        matcher.appendReplacement((StringBuilder)object, "");
                    }
                    continue block20;
                }
                case "translate": {
                    try {
                        String[] stringArray = StringUtils.split(string, "|");
                        if (stringArray.length == 0) {
                            matcher.appendReplacement((StringBuilder)object, "");
                            continue block20;
                        }
                        String string2 = Manager.of(Translator.class).language();
                        int n = 0;
                        if (stringArray.length > 1 && stringArray[0].length() == 2) {
                            string2 = stringArray[0];
                            n = 1;
                        }
                        String string3 = StringUtils.substitute(Manager.of(Translator.class).get(stringArray[n], string2), "{}", Arrays.copyOfRange(stringArray, n, stringArray.length));
                        matcher.appendReplacement((StringBuilder)object, Matcher.quoteReplacement(string3));
                    }
                    catch (Exception exception) {
                        matcher.appendReplacement((StringBuilder)object, "");
                    }
                    continue block20;
                }
            }
            matcher.appendReplacement((StringBuilder)object, "");
        }
        matcher.appendTail((StringBuilder)object);
        return Data.of(((StringBuilder)object).toString());
    }

    public boolean optional() {
        return this.optional;
    }

    public Parameter optional(boolean bl) {
        this.optional = bl;
        return this;
    }

    public int min() {
        return this.min;
    }

    public Parameter min(int n) {
        this.min = n;
        return this;
    }

    public int max() {
        return this.max;
    }

    public Parameter max(int n) {
        this.max = n;
        return this;
    }

    public Set<String> values() {
        return this.values;
    }

    public Parameter values(String ... stringArray) {
        for (String string : stringArray) {
            this.values.add(string);
        }
        return this;
    }

    public Functions.Predicate<String> rule() {
        return this.rule;
    }

    public Parameter rule(Functions.Predicate<String> predicate) {
        this.rule = predicate;
        return this;
    }

    public Parameter rule(String string) {
        this.rule = string2 -> StringUtils.isComposedOf(string2, string);
        return this;
    }

    @Override
    public Data export() {
        return Documented.super.export().put("bindable", this.bindable()).put("defaultValue", this.defaultValue()).put("optional", this.optional()).put("min", this.min()).put("max", this.max()).put("format", this.format()).put("values", this.values()).put("rule", this.rule != null);
    }

    public static class Rule {
        public static final Functions.Predicate<String> UPPER = StringUtils::isUpper;
        public static final Functions.Predicate<String> LOWER = StringUtils::isLower;
        public static final Functions.Predicate<String> DIGIT = StringUtils::isDigit;
        public static final Functions.Predicate<String> ALPHA = StringUtils::isAlpha;
        public static final Functions.Predicate<String> ALPHANUM = StringUtils::isAlphaNum;
        public static final Functions.Predicate<String> ALPHANUMSPACE = string -> StringUtils.isAlphaNum(string, true);
        public static final Functions.Predicate<String> BOOLEAN = StringUtils::isBoolean;
        public static final Functions.Predicate<String> BASE64 = StringUtils::isBase64;
        public static final Functions.Predicate<String> HEXA = StringUtils::isHexa;
        public static final Functions.Predicate<String> INTEGER = StringUtils::isInteger;
        public static final Functions.Predicate<String> FLOAT = StringUtils::isFloatingPoint;
        public static final Functions.Predicate<String> PATH = StringUtils::isPath;
        public static final Functions.Predicate<String> WILDCARD_PATH = StringUtils::isWildcardPath;
        public static final Functions.Predicate<String> ID = string -> string != null && string.length() == 25 && string.charAt(8) == '-' && StringUtils.isHexa(string.substring(0, 8)) && StringUtils.isHexa(string.substring(9));
        public static final Functions.Predicate<String> EMAIL = StringUtils::isEmailSimple;
        public static final Functions.Predicate<String> FILENAME = string -> StringUtils.isComposedOf(string, "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789_.-");
        public static final Functions.Predicate<String> URL = StringUtils::isUrlSimple;
        public static final Functions.Predicate<String> JSON_MAP = string -> string != null && string.startsWith("{") && string.endsWith("}");
        public static final Functions.Predicate<String> JSON_LIST = string -> string != null && string.startsWith("[") && string.endsWith("]");

        private Rule() {
        }
    }

    public static class Format {
        public static final String TEXT = "text";
        public static final String LONGTEXT = "longtext";
        public static final String NUMBER = "number";
        public static final String PASSWORD = "password";
        public static final String BOOLEAN = "boolean";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String DATETIME = "datetime";
        public static final String JSON = "json";
        public static final String CODE = "code";
        public static final String SELECT = "select";
        public static final String OPAQUE = "opaque";

        private Format() {
        }
    }
}

