/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.entity.Registry;
import aeonics.entity.security.Policy;
import aeonics.entity.security.Provider;
import aeonics.entity.security.Role;
import aeonics.entity.security.Token;
import aeonics.entity.security.User;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;

public abstract class Security
extends Manager.Type {
    @Override
    public final Class<? extends Manager.Type> manager() {
        return Security.class;
    }

    public static Security get() {
        return Manager.of(Security.class);
    }

    public abstract String randomHash();

    public abstract String hash(InputStream var1);

    public String hash(String string) {
        return this.hash(string == null ? null : string.getBytes(StandardCharsets.ISO_8859_1), null);
    }

    public String hash(byte[] byArray) {
        return this.hash(byArray, null);
    }

    public String hash(String string, String string2) {
        return this.hash(string == null ? null : string.getBytes(StandardCharsets.ISO_8859_1), string2 == null ? null : string2.getBytes(StandardCharsets.ISO_8859_1));
    }

    public abstract String hash(byte[] var1, byte[] var2);

    public String encrypt(String string, String string2) {
        return this.encrypt(string == null ? null : string.getBytes(StandardCharsets.ISO_8859_1), string2 == null ? null : string2.getBytes(StandardCharsets.ISO_8859_1));
    }

    public abstract String encrypt(byte[] var1, byte[] var2);

    public abstract String encrypt(byte[] var1, PublicKey var2);

    public String encrypt(byte[] byArray, Certificate certificate) {
        return this.encrypt(byArray, certificate.getPublicKey());
    }

    public String decrypt(String string, String string2) {
        return new String(this.decrypt(string, string2 == null ? null : string2.getBytes(StandardCharsets.ISO_8859_1)));
    }

    public abstract byte[] decrypt(String var1, byte[] var2);

    public abstract byte[] decrypt(String var1, PrivateKey var2);

    public abstract boolean verify(String var1, byte[] var2, PublicKey var3);

    public boolean verify(String string, byte[] byArray, Certificate certificate) {
        return this.verify(string, byArray, certificate.getPublicKey());
    }

    public abstract String sign(byte[] var1, PrivateKey var2);

    public List<Provider.Type> providers(String string) {
        return (List)Registry.of(Provider.class).get(type -> {
            try {
                return type.active() && type.supports(string);
            }
            catch (Exception exception) {
                Manager.of(Logger.class).warning(Security.class, (Throwable)exception);
                return false;
            }
        });
    }

    public User.Type authenticate(Provider.Type type, Data data) {
        if (type == null || !type.active()) {
            return User.ANONYMOUS;
        }
        try {
            User.Type type2 = type.authenticate(data);
            if (type2 == null) {
                return User.ANONYMOUS;
            }
            return type2;
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Security.class, (Throwable)exception);
            return User.ANONYMOUS;
        }
    }

    public boolean granted(User.Type type, String string, Data data) {
        if (type == null) {
            return false;
        }
        if (type == User.SYSTEM) {
            return true;
        }
        if (type.hasRole(Role.SUPERADMIN)) {
            return true;
        }
        return !this.isExplicitlyDenied(type, string, data) && this.isExplicitlyAllowed(type, string, data);
    }

    public boolean isExplicitlyDenied(User.Type type, String string, Data data) {
        if (type == null || string == null) {
            return false;
        }
        if (type == User.SYSTEM) {
            return false;
        }
        if (type.hasRole(Role.SUPERADMIN)) {
            return false;
        }
        try {
            for (Policy.Type type2 : Registry.of(Policy.class)) {
                if (!type2.valueOf("scope").equals(string) || !type2.isDenied(type, data)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Security.class, (Throwable)exception);
            return false;
        }
    }

    public boolean isExplicitlyAllowed(User.Type type, String string, Data data) {
        if (type == null || string == null) {
            return false;
        }
        if (type == User.SYSTEM) {
            return true;
        }
        if (type.hasRole(Role.SUPERADMIN)) {
            return true;
        }
        try {
            for (Policy.Type type2 : Registry.of(Policy.class)) {
                if (!type2.valueOf("scope").equals(string) || !type2.isAllowed(type, data)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Manager.of(Logger.class).warning(Security.class, (Throwable)exception);
            return false;
        }
    }

    public abstract Token generateToken(User.Type var1, long var2, boolean var4, String ... var5);

    public abstract Token authenticate(String var1, boolean var2);

    public abstract void revokeToken(Token var1);

    public abstract void clearTokens(User.Type var1);

    public abstract Collection<Token> listTokens(User.Type var1);
}

