/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Item;
import aeonics.template.Template;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Scheduler
extends Manager.Type {
    @Override
    public final Class<? extends Manager.Type> manager() {
        return Scheduler.class;
    }

    public static Scheduler get() {
        return Manager.of(Scheduler.class);
    }

    public abstract void at(Consumer<ZonedDateTime> var1, ZonedDateTime var2);

    public void in(Consumer<ZonedDateTime> consumer, long l) {
        this.at(consumer, ZonedDateTime.now().withNano(0).plus(l, ChronoUnit.MILLIS));
    }

    public Cron.Type every(Consumer<ZonedDateTime> consumer, long l, ChronoUnit chronoUnit) {
        return this.every(consumer, l, chronoUnit, ZonedDateTime.now().withNano(0));
    }

    public Cron.Type every(Consumer<ZonedDateTime> consumer, long l, ChronoUnit chronoUnit, ZonedDateTime zonedDateTime) {
        long l2 = l;
        String string = "";
        switch (chronoUnit) {
            case NANOS: {
                l2 /= 1000L;
            }
            case MICROS: {
                l2 /= 1000L;
            }
            case MILLIS: {
                l2 /= 1000L;
            }
            case SECONDS: {
                string = RRULE.Freq.SECONDLY.toString();
                break;
            }
            case MINUTES: {
                string = RRULE.Freq.MINUTELY.toString();
                break;
            }
            case HOURS: {
                string = RRULE.Freq.HOURLY.toString();
                break;
            }
            case HALF_DAYS: {
                l2 /= 2L;
            }
            case DAYS: {
                string = RRULE.Freq.DAILY.toString();
                break;
            }
            case WEEKS: {
                string = RRULE.Freq.WEEKLY.toString();
                break;
            }
            case MONTHS: {
                string = RRULE.Freq.MONTHLY.toString();
                break;
            }
            case FOREVER: {
                l2 *= 1000L;
            }
            case ERAS: {
                l2 *= 1000L;
            }
            case MILLENNIA: {
                l2 *= 10L;
            }
            case CENTURIES: {
                l2 *= 10L;
            }
            case DECADES: {
                l2 *= 10L;
            }
            case YEARS: {
                string = RRULE.Freq.YEARLY.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit in RRULE");
            }
        }
        String string2 = "RRULE:FREQ=" + string + ";INTERVAL=" + l2;
        Object r = ((Cron.Type)((Cron.Type)((Cron.Type)((Template)((Template)new Cron(){}.template().summary("Runs a task at regular interval")).description("This task runs every " + l + " " + chronoUnit.toString() + " starting from " + (zonedDateTime == null ? ZonedDateTime.now().withNano(0) : zonedDateTime))).create()).task(consumer)).start(zonedDateTime == null ? ZonedDateTime.now().withNano(0) : zonedDateTime)).rule(string2);
        this.refresh();
        return r;
    }

    public abstract void refresh();

    public static class RRULE {
        private static Map<Weekday, Integer> weekDayMap = new EnumMap<Weekday, Integer>(Weekday.class);
        private static Map<Part, Boolean> allowsMultipleValues;
        private Freq freq = null;
        private int count = -1;
        private ZonedDateTime until = null;
        private int interval = 1;
        private ZonedDateTime referenceStart = null;
        private Data definition = Data.map();

        public RRULE(String string, ZonedDateTime zonedDateTime) {
            this.parse(string.toUpperCase());
            if (this.freq == null) {
                throw new IllegalArgumentException("FREQ is required");
            }
            if (this.interval <= 0) {
                throw new IllegalArgumentException("INTERVAL must not be less than 1");
            }
            if (this.freq != Freq.YEARLY && this.definition.containsKey("BYWEEKNO")) {
                throw new IllegalArgumentException("BYWEEKNO is only valid when FREQ=YEARLY");
            }
            if (this.freq == Freq.DAILY && this.definition.containsKey("BYYEARDAY")) {
                throw new IllegalArgumentException("BYYEARDAY is not valid when FREQ=DAILY");
            }
            if (this.freq == Freq.WEEKLY && this.definition.containsKey("BYYEARDAY")) {
                throw new IllegalArgumentException("BYYEARDAY is not valid when FREQ=WEEKLY");
            }
            if (this.freq == Freq.MONTHLY && this.definition.containsKey("BYYEARDAY")) {
                throw new IllegalArgumentException("BYYEARDAY is not valid when FREQ=MONTHLY");
            }
            if (this.freq == Freq.WEEKLY && this.definition.containsKey("BYMONTHDAY")) {
                throw new IllegalArgumentException("BYMONTHDAY is not valid when FREQ=WEEKLY");
            }
            if (!(!this.definition.containsKey("BYSETPOS") || this.definition.containsKey("BYSECOND") || this.definition.containsKey("BYMINUTE") || this.definition.containsKey("BYHOUR") || this.definition.containsKey("BYDAY") || this.definition.containsKey("BYMONTHDAY") || this.definition.containsKey("BYYEARDAY") || this.definition.containsKey("BYWEEKNO") || this.definition.containsKey("BYMONTH"))) {
                throw new IllegalArgumentException("BYSETPOS is only valid when another BYxxx part is set");
            }
            this.referenceStart = zonedDateTime;
            if (this.definition.containsKey("BYSETPOS")) {
                throw new UnsupportedOperationException("BYSETPOS is not supported");
            }
            if (this.definition.containsKey("BYWEEKNO")) {
                throw new UnsupportedOperationException("BYWEEKNO is not supported");
            }
            if (this.definition.containsKey("BYYEARDAY")) {
                throw new UnsupportedOperationException("BYYEARDAY is not supported");
            }
        }

        private void parse(String string) {
            String string2 = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            if (string.startsWith("RRULE:")) {
                string = string.substring(6);
            }
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ';' || i == string.length() - 1) {
                    if (string2 == null) continue;
                    if (i >= string.length() - 1) {
                        linkedList.add(string.substring(n));
                    } else {
                        linkedList.add(string.substring(n, i));
                    }
                    n = i + 1;
                    this.addPart(string2, linkedList);
                    string2 = null;
                    linkedList = new LinkedList();
                    continue;
                }
                if (c == '=') {
                    string2 = string.substring(n, i);
                    n = i + 1;
                    continue;
                }
                if (c != ',') continue;
                linkedList.add(string.substring(n, i));
                n = i + 1;
            }
        }

        private void addPart(String string3, List<String> list) {
            if (this.definition.containsKey(string3)) {
                throw new IllegalArgumentException(string3 + " must not occur more than once");
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException(string3 + " value must not be empty");
            }
            switch (Part.valueOf(string3)) {
                case FREQ: {
                    this.freq = Freq.valueOf(list.get(0));
                    break;
                }
                case INTERVAL: {
                    this.interval = Integer.parseInt(list.get(0));
                    break;
                }
                case UNTIL: {
                    if (this.definition.containsKey(Part.COUNT.toString())) {
                        throw new IllegalArgumentException("UNTIL cannot be use in conjunction with COUNT");
                    }
                    this.until = this.parseDate(list.get(0));
                    break;
                }
                case COUNT: {
                    if (this.definition.containsKey(Part.UNTIL.toString())) {
                        throw new IllegalArgumentException("COUNT cannot be use in conjunction with UNTIL");
                    }
                    this.count = Integer.parseInt(list.get(0));
                    break;
                }
            }
            if (!Boolean.TRUE.equals(allowsMultipleValues.get((Object)Part.valueOf(string3)))) {
                if (list.size() > 1) {
                    throw new IllegalArgumentException(string3 + " accepts only one value");
                }
                this.definition.put(string3, list.get(0));
            } else {
                if (string3.equals("BYSECOND") || string3.equals("BYMINUTE") || string3.equals("BYHOUR") || string3.equals("BYMONTH")) {
                    list.sort((string, string2) -> {
                        Integer n = Integer.parseInt(string);
                        Integer n2 = Integer.parseInt(string2);
                        return n.compareTo(n2);
                    });
                }
                list = new ArrayList<String>(new LinkedHashSet<String>(list));
                this.definition.put(string3, list);
            }
        }

        public ZonedDateTime parseDate(String string) {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            ZoneId zoneId = TimeZone.getDefault().toZoneId();
            if (string.startsWith("TZID=")) {
                int n7 = string.indexOf(58);
                zoneId = ZoneId.of(string.substring(5, n7));
                string = string.substring(n7 + 1);
            }
            n = Integer.parseInt(string.substring(0, 4));
            n2 = Integer.parseInt(string.substring(4, 6));
            n3 = Integer.parseInt(string.substring(6, 8));
            if (string.length() > 8) {
                n4 = Integer.parseInt(string.substring(9, 11));
                n5 = Integer.parseInt(string.substring(11, 13));
                n6 = Integer.parseInt(string.substring(13, 15));
            }
            if (string.endsWith("Z")) {
                zoneId = ZoneId.of("UTC");
            }
            return ZonedDateTime.of(n, n2, n3, n4, n5, n6, 0, zoneId);
        }

        public Iterator<ZonedDateTime> iterator(ZonedDateTime zonedDateTime) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(this.referenceStart.getZone());
            if (this.freq == Freq.MONTHLY && !this.definition.containsKey("BYDAY") && !this.definition.containsKey("BYMONTHDAY")) {
                zonedDateTime = this.referenceStart.getDayOfMonth() > zonedDateTime.getMonth().length(zonedDateTime.toLocalDate().isLeapYear()) ? zonedDateTime.withDayOfMonth(zonedDateTime.getMonth().length(zonedDateTime.toLocalDate().isLeapYear())) : zonedDateTime.withDayOfMonth(this.referenceStart.getDayOfMonth());
            } else if (this.freq == Freq.WEEKLY && !this.definition.containsKey("BYDAY") && !zonedDateTime.getDayOfWeek().equals(this.referenceStart.getDayOfWeek())) {
                int n = this.referenceStart.getDayOfWeek().getValue() - zonedDateTime.getDayOfWeek().getValue();
                if (n < 0) {
                    n += 7;
                }
                zonedDateTime = zonedDateTime.plusDays(n);
            }
            switch (this.freq) {
                case YEARLY: {
                    zonedDateTime = zonedDateTime.withMonth(this.referenceStart.getMonthValue());
                }
                case MONTHLY: 
                case WEEKLY: 
                case DAILY: {
                    zonedDateTime = zonedDateTime.withHour(this.referenceStart.getHour());
                }
                case HOURLY: {
                    zonedDateTime = zonedDateTime.withMinute(this.referenceStart.getMinute());
                }
                case MINUTELY: {
                    zonedDateTime = zonedDateTime.withSecond(this.referenceStart.getSecond());
                }
                case SECONDLY: {
                    zonedDateTime = zonedDateTime.withNano(0);
                }
            }
            final ZonedDateTime zonedDateTime2 = zonedDateTime;
            return new Iterator<ZonedDateTime>(){
                private int counter = 0;
                private ZonedDateTime previous = null;
                private ZonedDateTime next = null;
                private Map<String, Integer> index = new HashMap<String, Integer>();

                @Override
                public boolean hasNext() {
                    if (this.previous == null) {
                        this.initialize();
                    }
                    if (this.next == null) {
                        this.computeNext();
                    }
                    if (count > 0 && this.counter >= count) {
                        return false;
                    }
                    return until == null || !this.next.isAfter(until);
                }

                @Override
                public ZonedDateTime next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    this.previous = this.next;
                    this.next = null;
                    return this.previous;
                }

                private void initialize() {
                    int n;
                    int n2;
                    this.previous = count > 0 ? referenceStart.withNano(0) : zonedDateTime2.withNano(0);
                    this.next = this.previous;
                    if (definition.containsKey("BYMONTH")) {
                        n2 = 0;
                        while (true) {
                            if (n2 >= definition.get("BYMONTH").size()) {
                                this.next = this.next.withMonth(definition.get("BYMONTH").asInt(0));
                                this.index.put("BYMONTH", 0);
                                if (this.next.isAfter(referenceStart)) break;
                                this.nextYear();
                                break;
                            }
                            n = definition.get("BYMONTH").asInt(n2);
                            if (n >= this.next.getMonthValue()) {
                                this.next = this.next.withMonth(n);
                                this.index.put("BYMONTH", n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (definition.containsKey("BYDAY") || definition.containsKey("BYMONTHDAY")) {
                        List<Integer> list = this.currentMonthValidDays();
                        n = 0;
                        while (true) {
                            if (n >= list.size()) {
                                this.next = this.next.withDayOfMonth(list.get(0));
                                this.index.put("BYDAY-BYMONTHDAY", 0);
                                if (!this.next.isAfter(referenceStart)) {
                                    this.nextMonth();
                                }
                                this.next = this.next.withDayOfMonth(this.currentMonthValidDays().get(0));
                                break;
                            }
                            int n3 = list.get(n);
                            if (n3 >= this.next.getDayOfMonth()) {
                                this.next = this.next.withDayOfMonth(n3);
                                this.index.put("BYDAY-BYMONTHDAY", n);
                                break;
                            }
                            ++n;
                        }
                    }
                    if (definition.containsKey("BYHOUR")) {
                        n2 = 0;
                        while (true) {
                            if (n2 >= definition.get("BYHOUR").size()) {
                                this.next = this.next.withHour(definition.get("BYHOUR").asInt(0));
                                this.index.put("BYHOUR", 0);
                                if (this.next.isAfter(referenceStart)) break;
                                this.nextDay();
                                break;
                            }
                            n = definition.get("BYHOUR").asInt(n2);
                            if (n >= this.next.getHour()) {
                                this.next = this.next.withHour(n);
                                this.index.put("BYHOUR", n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (definition.containsKey("BYMINUTE")) {
                        n2 = 0;
                        while (true) {
                            if (n2 >= definition.get("BYMINUTE").size()) {
                                this.next = this.next.withMinute(definition.get("BYMINUTE").asInt(0));
                                this.index.put("BYMINUTE", 0);
                                if (this.next.isAfter(referenceStart)) break;
                                this.nextHour();
                                break;
                            }
                            n = definition.get("BYMINUTE").asInt(n2);
                            if (n >= this.next.getMinute()) {
                                this.next = this.next.withMinute(n);
                                this.index.put("BYMINUTE", n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (definition.containsKey("BYSECOND")) {
                        n2 = 0;
                        while (true) {
                            if (n2 >= definition.get("BYSECOND").size()) {
                                this.next = this.next.withSecond(definition.get("BYSECOND").asInt(0));
                                this.index.put("BYSECOND", 0);
                                if (this.next.isAfter(referenceStart)) break;
                                this.nextMinute();
                                break;
                            }
                            n = definition.get("BYSECOND").asInt(n2);
                            if (n >= this.next.getSecond()) {
                                this.next = this.next.withSecond(n);
                                this.index.put("BYSECOND", n2);
                                break;
                            }
                            ++n2;
                        }
                    }
                    while (this.hasNext() && !this.next.isAfter(zonedDateTime2)) {
                        this.next();
                    }
                }

                public void computeNext() {
                    this.next = this.previous;
                    this.nextSecond();
                    ++this.counter;
                }

                private void nextSecond() {
                    if (!definition.containsKey("BYSECOND")) {
                        switch (freq) {
                            case SECONDLY: {
                                if (this.next.getSecond() + interval <= 59) {
                                    this.next = this.next.plusSeconds(interval);
                                    break;
                                }
                                this.nextMinute();
                                this.next = this.next.withSecond(this.next.getSecond() + interval - 60);
                                break;
                            }
                            case YEARLY: 
                            case MONTHLY: 
                            case WEEKLY: 
                            case DAILY: 
                            case HOURLY: 
                            case MINUTELY: {
                                this.next = this.next.withSecond(referenceStart.getSecond());
                                this.nextMinute();
                            }
                        }
                    } else {
                        int n;
                        boolean bl = false;
                        int n2 = this.index.get("BYSECOND") + 1;
                        this.index.put("BYSECOND", n2);
                        if (n2 >= definition.get("BYSECOND").size()) {
                            n2 = 0;
                            this.index.put("BYSECOND", 0);
                            bl = true;
                        }
                        if ((n = definition.get("BYSECOND").asInt(n2)) < 0 || n > 59) {
                            Manager.of(Logger.class).warning(Scheduler.class, "Invalid time unit in RRULE {}. Setting to 0 instead.", definition);
                            n = 0;
                        }
                        if (n <= this.next.getSecond()) {
                            bl = true;
                        }
                        this.next = this.next.withSecond(n);
                        if (bl) {
                            this.nextMinute();
                        }
                    }
                }

                private void nextMinute() {
                    if (!definition.containsKey("BYMINUTE")) {
                        switch (freq) {
                            case SECONDLY: {
                                this.next = this.next.plusMinutes(1L);
                                break;
                            }
                            case MINUTELY: {
                                if (this.next.getMinute() + interval <= 59) {
                                    this.next = this.next.plusMinutes(interval);
                                    break;
                                }
                                this.nextHour();
                                this.next = this.next.withMinute(this.next.getMinute() + interval - 60);
                                break;
                            }
                            case YEARLY: 
                            case MONTHLY: 
                            case WEEKLY: 
                            case DAILY: 
                            case HOURLY: {
                                this.next = this.next.withMinute(referenceStart.getMinute());
                                this.nextHour();
                            }
                        }
                    } else {
                        int n;
                        boolean bl = false;
                        int n2 = this.index.get("BYMINUTE") + 1;
                        this.index.put("BYMINUTE", n2);
                        if (n2 >= definition.get("BYMINUTE").size()) {
                            n2 = 0;
                            this.index.put("BYMINUTE", 0);
                            bl = true;
                        }
                        if ((n = definition.get("BYMINUTE").asInt(n2)) < 0 || n > 59) {
                            Manager.of(Logger.class).warning(Scheduler.class, "Invalid time unit in RRULE {}. Setting to 0 instead.", definition);
                            n = 0;
                        }
                        if (n <= this.next.getMinute()) {
                            bl = true;
                        }
                        this.next = this.next.withMinute(n);
                        if (bl) {
                            this.nextHour();
                        }
                    }
                }

                private void nextHour() {
                    if (!definition.containsKey("BYHOUR")) {
                        switch (freq) {
                            case MINUTELY: 
                            case SECONDLY: {
                                this.next = this.next.plusHours(1L);
                                break;
                            }
                            case HOURLY: {
                                if (this.next.getHour() + interval <= 23) {
                                    this.next = this.next.plusHours(interval);
                                    break;
                                }
                                this.nextDay();
                                this.next = this.next.withHour(this.next.getHour() + interval - 24);
                                break;
                            }
                            case YEARLY: 
                            case MONTHLY: 
                            case WEEKLY: 
                            case DAILY: {
                                this.next = this.next.withHour(referenceStart.getHour());
                                this.nextDay();
                            }
                        }
                    } else {
                        int n;
                        boolean bl = false;
                        int n2 = this.index.get("BYHOUR") + 1;
                        this.index.put("BYHOUR", n2);
                        if (n2 >= definition.get("BYHOUR").size()) {
                            n2 = 0;
                            this.index.put("BYHOUR", 0);
                            bl = true;
                        }
                        if ((n = definition.get("BYHOUR").asInt(n2)) < 0 || n > 23) {
                            Manager.of(Logger.class).warning(Scheduler.class, "Invalid time unit in RRULE {}. Setting to 0 instead.", definition);
                            n = 0;
                        }
                        if (n <= this.next.getHour()) {
                            bl = true;
                        }
                        this.next = this.next.withHour(n);
                        if (bl) {
                            this.nextDay();
                        }
                    }
                }

                private void nextDay() {
                    if (!definition.containsKey("BYDAY") && !definition.containsKey("BYMONTHDAY")) {
                        switch (freq) {
                            case HOURLY: 
                            case MINUTELY: 
                            case SECONDLY: {
                                this.next = this.next.plusDays(1L);
                                break;
                            }
                            case DAILY: {
                                if (this.next.getDayOfMonth() + interval <= this.next.toLocalDate().lengthOfMonth()) {
                                    this.next = this.next.plusDays(interval);
                                    break;
                                }
                                int n = this.next.toLocalDate().lengthOfMonth();
                                this.nextMonth();
                                this.next = this.next.withDayOfMonth(this.next.getDayOfMonth() + interval - n);
                                break;
                            }
                            case WEEKLY: {
                                int n = 7 * interval;
                                if (this.next.getDayOfMonth() + n <= this.next.toLocalDate().lengthOfMonth()) {
                                    this.next = this.next.plusDays(n);
                                    break;
                                }
                                int n2 = this.next.toLocalDate().lengthOfMonth() - 1;
                                this.nextMonth();
                                this.next = this.next.withDayOfMonth(this.next.getDayOfMonth() + n - n2 - 1);
                                break;
                            }
                            case YEARLY: 
                            case MONTHLY: {
                                this.nextMonth();
                                this.next = this.next.withDayOfMonth(Math.min(referenceStart.getDayOfMonth(), this.next.toLocalDate().lengthOfMonth()));
                            }
                        }
                    } else {
                        int n;
                        List<Integer> list = this.currentMonthValidDays();
                        boolean bl = false;
                        int n3 = this.index.get("BYDAY-BYMONTHDAY") + 1;
                        this.index.put("BYDAY-BYMONTHDAY", n3);
                        if (n3 >= list.size()) {
                            n3 = 0;
                            this.index.put("BYDAY-BYMONTHDAY", 0);
                            bl = true;
                        }
                        if ((n = list.get(n3).intValue()) < 0 || n > 31) {
                            Manager.of(Logger.class).warning(Scheduler.class, "Invalid time unit in RRULE {}. Setting to 0 instead.", definition);
                            n = 0;
                        }
                        if (n <= this.next.getDayOfMonth()) {
                            bl = true;
                        } else {
                            this.next = this.next.withDayOfMonth(n);
                        }
                        if (bl) {
                            this.nextMonth();
                            this.next = this.next.withDayOfMonth(this.currentMonthValidDays().get(0));
                        }
                    }
                }

                private List<Integer> currentMonthValidDays() {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int n = this.next.toLocalDate().lengthOfMonth();
                    for (int i = 1; i <= n; ++i) {
                        arrayList.add(i);
                    }
                    if (definition.containsKey("BYDAY")) {
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        int n2 = this.next.withDayOfMonth(1).getDayOfWeek().getValue();
                        for (Data data : definition.get("BYDAY")) {
                            int n3 = weekDayMap.get((Object)Weekday.valueOf(data.asString()));
                            for (int i = 0; i < 6; ++i) {
                                int n4 = 1 - n2 + n3 + 7 * i;
                                if (n4 < 0) {
                                    n4 = n - n4;
                                }
                                if (n4 <= 0 || n4 > n) continue;
                                arrayList2.add(n4);
                            }
                        }
                        arrayList.retainAll(arrayList2);
                    }
                    if (definition.containsKey("BYMONTHDAY")) {
                        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                        for (Object object : definition.get("BYMONTHDAY")) {
                            int n5 = object.asInt();
                            if (n5 < 0) {
                                n5 = n - n5;
                            }
                            if (n5 <= 0 || n5 > n) continue;
                            arrayList3.add(n5);
                        }
                        arrayList.retainAll(arrayList3);
                    }
                    return new ArrayList<Integer>(new TreeSet(arrayList));
                }

                private void nextMonth() {
                    if (!definition.containsKey("BYMONTH")) {
                        switch (freq) {
                            case WEEKLY: 
                            case DAILY: 
                            case HOURLY: 
                            case MINUTELY: 
                            case SECONDLY: {
                                this.next = this.next.plusMonths(1L);
                                break;
                            }
                            case MONTHLY: {
                                if (this.next.getMonthValue() + interval <= 12) {
                                    this.next = this.next.plusMonths(interval);
                                    break;
                                }
                                this.nextYear();
                                this.next = this.next.withMonth(this.next.getMonthValue() + interval - 12);
                                break;
                            }
                            case YEARLY: {
                                this.next = this.next.withMonth(referenceStart.getMonthValue());
                                this.nextYear();
                            }
                        }
                    } else {
                        int n;
                        boolean bl = false;
                        int n2 = this.index.get("BYMONTH") + 1;
                        this.index.put("BYMONTH", n2);
                        if (n2 >= definition.get("BYMONTH").size()) {
                            n2 = 0;
                            this.index.put("BYMONTH", 0);
                            bl = true;
                        }
                        if ((n = definition.get("BYMONTH").asInt(n2)) < 1 || n > 12) {
                            Manager.of(Logger.class).warning(Scheduler.class, "Invalid time unit in RRULE {}. Setting to 0 instead.", definition);
                            n = 0;
                        }
                        if (n <= this.next.getMonthValue()) {
                            bl = true;
                        }
                        this.next = this.next.withMonth(n);
                        if (bl) {
                            this.nextYear();
                        }
                    }
                }

                private void nextYear() {
                    switch (freq) {
                        case MONTHLY: 
                        case WEEKLY: 
                        case DAILY: 
                        case HOURLY: 
                        case MINUTELY: 
                        case SECONDLY: {
                            this.next = this.next.plusYears(1L);
                            break;
                        }
                        case YEARLY: {
                            this.next = this.next.plusYears(interval);
                        }
                    }
                }
            };
        }

        static {
            weekDayMap.put(Weekday.SU, DayOfWeek.SUNDAY.getValue());
            weekDayMap.put(Weekday.MO, DayOfWeek.MONDAY.getValue());
            weekDayMap.put(Weekday.TU, DayOfWeek.TUESDAY.getValue());
            weekDayMap.put(Weekday.WE, DayOfWeek.WEDNESDAY.getValue());
            weekDayMap.put(Weekday.TH, DayOfWeek.THURSDAY.getValue());
            weekDayMap.put(Weekday.FR, DayOfWeek.FRIDAY.getValue());
            weekDayMap.put(Weekday.SA, DayOfWeek.SATURDAY.getValue());
            allowsMultipleValues = new EnumMap<Part, Boolean>(Part.class);
            allowsMultipleValues.put(Part.FREQ, false);
            allowsMultipleValues.put(Part.UNTIL, false);
            allowsMultipleValues.put(Part.COUNT, false);
            allowsMultipleValues.put(Part.INTERVAL, false);
            allowsMultipleValues.put(Part.BYSECOND, true);
            allowsMultipleValues.put(Part.BYMINUTE, true);
            allowsMultipleValues.put(Part.BYHOUR, true);
            allowsMultipleValues.put(Part.BYDAY, true);
            allowsMultipleValues.put(Part.BYMONTHDAY, true);
            allowsMultipleValues.put(Part.BYYEARDAY, true);
            allowsMultipleValues.put(Part.BYWEEKNO, true);
            allowsMultipleValues.put(Part.BYMONTH, true);
            allowsMultipleValues.put(Part.BYSETPOS, true);
            allowsMultipleValues.put(Part.WKST, false);
        }

        private static enum Weekday {
            SU("SU"),
            MO("MO"),
            TU("TU"),
            WE("WE"),
            TH("TH"),
            FR("FR"),
            SA("SA");

            private String name;

            private Weekday(String string2) {
                this.name = string2;
            }

            public String toString() {
                return this.name;
            }
        }

        private static enum Freq {
            SECONDLY("SECONDLY"),
            MINUTELY("MINUTELY"),
            HOURLY("HOURLY"),
            DAILY("DAILY"),
            WEEKLY("WEEKLY"),
            MONTHLY("MONTHLY"),
            YEARLY("YEARLY");

            private String name;

            private Freq(String string2) {
                this.name = string2;
            }

            public String toString() {
                return this.name;
            }
        }

        private static enum Part {
            FREQ("FREQ"),
            UNTIL("UNTIL"),
            COUNT("COUNT"),
            INTERVAL("INTERVAL"),
            BYSECOND("BYSECOND"),
            BYMINUTE("BYMINUTE"),
            BYHOUR("BYHOUR"),
            BYDAY("BYDAY"),
            BYMONTHDAY("BYMONTHDAY"),
            BYYEARDAY("BYYEARDAY"),
            BYWEEKNO("BYWEEKNO"),
            BYMONTH("BYMONTH"),
            BYSETPOS("BYSETPOS"),
            WKST("WKST");

            private String name;

            private Part(String string2) {
                this.name = string2;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static abstract class Cron
    extends Item<Type> {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        protected Class<? extends Cron> category() {
            return Cron.class;
        }

        public static class Type
        extends Entity
        implements Consumer<ZonedDateTime> {
            private Consumer<ZonedDateTime> task = null;
            private ZonedDateTime start = null;
            private String rrule = null;
            private Iterator<ZonedDateTime> iterator = null;
            private ZonedDateTime next = null;

            @Override
            public boolean internal() {
                return true;
            }

            @Override
            public Snapshotable.SnapshotMode snapshotMode() {
                return Snapshotable.SnapshotMode.NONE;
            }

            @Override
            public void accept(ZonedDateTime zonedDateTime) {
                if (this.task != null) {
                    this.task.accept(zonedDateTime);
                }
            }

            public Consumer<ZonedDateTime> task() {
                return this.task;
            }

            public <R extends Type> R task(Consumer<ZonedDateTime> consumer) {
                this.task = consumer;
                return (R)this;
            }

            public ZonedDateTime start() {
                return this.start;
            }

            public <R extends Type> R start(ZonedDateTime zonedDateTime) {
                this.start = zonedDateTime;
                this.reset();
                return (R)this;
            }

            public String rule() {
                return this.rrule;
            }

            public <R extends Type> R rule(String string) {
                this.rrule = string;
                this.reset();
                return (R)this;
            }

            @Override
            public final String category() {
                return StringUtils.toLowerCase(Cron.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                String string = this.rule();
                Consumer<ZonedDateTime> consumer = this.task();
                ZonedDateTime zonedDateTime = this.start();
                if (string == null || consumer == null || zonedDateTime == null || string.isBlank()) {
                    this.next = null;
                    this.iterator = null;
                    return;
                }
                Type type = this;
                synchronized (type) {
                    if (string.isBlank()) {
                        return;
                    }
                    RRULE rRULE = new RRULE(this.rule(), this.start());
                    ZonedDateTime zonedDateTime2 = ZonedDateTime.now().withNano(0).plusSeconds(rRULE.freq == RRULE.Freq.SECONDLY ? 0L : 5L);
                    this.iterator = rRULE.iterator(zonedDateTime.isAfter(zonedDateTime2) ? zonedDateTime : zonedDateTime2);
                    this.next = this.iterator.next();
                }
            }

            public ZonedDateTime next(boolean bl) {
                if (this.iterator == null) {
                    return null;
                }
                if (bl) {
                    ZonedDateTime zonedDateTime = ZonedDateTime.now().withNano(0);
                    do {
                        this.next = this.iterator.next();
                    } while (this.next != null && this.next.isBefore(zonedDateTime));
                }
                return this.next;
            }
        }
    }
}

