/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.entity.Entity;
import aeonics.manager.Logger;
import aeonics.template.Item;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Manager<T extends Type>
extends Item<T> {
    private static ConcurrentHashMap<String, Type> instances = new ConcurrentHashMap();

    public static <T extends Type> T of(Class<T> clazz) {
        return (T)((Type)clazz.cast(instances.get(StringUtils.toLowerCase(clazz))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Type> T set(Class<T> clazz, T t) {
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException("Invalid instance type");
        }
        ConcurrentHashMap<String, Type> concurrentHashMap = instances;
        synchronized (concurrentHashMap) {
            String string = StringUtils.toLowerCase(clazz);
            if (instances.containsKey(string)) {
                throw new RuntimeException("Instance is already set");
            }
            instances.put(string, t);
            Objects.requireNonNullElse(Manager.of(Logger.class), Logger.CONSOLE).config(Manager.class, "Manager of {} has been set to {} from module {}", string, t.getClass().getName(), t.getClass().getModule().getName());
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Type> void remove(Class<T> clazz) {
        ConcurrentHashMap<String, Type> concurrentHashMap = instances;
        synchronized (concurrentHashMap) {
            String string = StringUtils.toLowerCase(clazz);
            Type type = instances.remove(string);
            if (type != null) {
                Objects.requireNonNullElse(Manager.of(Logger.class), Logger.CONSOLE).config(Manager.class, "Manager of {} has been removed", string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Type> T replace(Class<T> clazz, T t) {
        if (!clazz.isInstance(t)) {
            throw new IllegalArgumentException("Invalid instance type");
        }
        ConcurrentHashMap<String, Type> concurrentHashMap = instances;
        synchronized (concurrentHashMap) {
            String string = StringUtils.toLowerCase(clazz);
            Type type = instances.put(string, t);
            if (type != null) {
                Objects.requireNonNullElse(Manager.of(Logger.class), Logger.CONSOLE).config(Manager.class, "Manager of {} has been replaced by {} from module {}", string, t.getClass().getName(), t.getClass().getModule().getName());
            } else {
                Objects.requireNonNullElse(Manager.of(Logger.class), Logger.CONSOLE).config(Manager.class, "Manager of {} has been set to {} from module {}", string, t.getClass().getName(), t.getClass().getModule().getName());
            }
            return t;
        }
    }

    public static Iterable<Type> all() {
        return Collections.unmodifiableCollection(instances.values());
    }

    @Override
    protected Class<? extends Manager<T>> category() {
        return Manager.class;
    }

    public static abstract class Type
    extends Entity {
        @Override
        public boolean internal() {
            return true;
        }

        @Override
        public Snapshotable.SnapshotMode snapshotMode() {
            return Snapshotable.SnapshotMode.NONE;
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Manager.class);
        }

        public abstract Class<? extends Type> manager();
    }
}

