/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.security.Group;
import aeonics.entity.security.Role;
import aeonics.entity.security.Rule;
import aeonics.entity.security.User;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.function.Supplier;

public abstract class Policy
extends Item<Type> {
    @Override
    public Template<? extends Type> template() {
        return ((Template)super.template().add((Parameter)((Parameter)((Parameter)new Parameter("scope").summary("Scope")).description("The scope to which this policy applies. The scope will be used as a filter to select applicable policies.")).format("text"))).add((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("rule").category(Rule.class)).summary("Rule")).description("The security rule to apply to this policy. The rule can be a logical combination of other rules.")).max(1));
    }

    @Override
    protected Class<? extends Policy> category() {
        return Policy.class;
    }

    public static class TargetedDeny
    extends TargetedPolicy {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Deny Target")).description("A policy that evaluates a security rule for specific targets (users, roles or groups) in order to deny access.");
        }

        public static class Type
        extends TargetedPolicy.Type {
            @Override
            public boolean isAllowed(User.Type type, Data data) {
                return false;
            }

            @Override
            public boolean isDenied(User.Type type, Data data) {
                if (type == User.SYSTEM) {
                    return false;
                }
                if (!this.appliesTo(type)) {
                    return false;
                }
                try {
                    for (Tuples.Tuple tuple : this.relations("rule")) {
                        Rule.Type type2 = (Rule.Type)((Entity)tuple.a).cast();
                        if (type2 == null) continue;
                        return type2.test(type, data);
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Rule.class, (Throwable)exception);
                }
                return false;
            }
        }
    }

    public static class TargetedAllow
    extends TargetedPolicy {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Allow Target")).description("A policy that evaluates a security rule for specific targets (users, roles or groups) in order to allow access.");
        }

        public static class Type
        extends TargetedPolicy.Type {
            @Override
            public boolean isDenied(User.Type type, Data data) {
                return false;
            }

            @Override
            public boolean isAllowed(User.Type type, Data data) {
                if (type == User.SYSTEM) {
                    return true;
                }
                if (!this.appliesTo(type)) {
                    return false;
                }
                try {
                    for (Tuples.Tuple tuple : this.relations("rule")) {
                        Rule.Type type2 = (Rule.Type)((Entity)tuple.a).cast();
                        if (type2 == null) continue;
                        return type2.test(type, data);
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Rule.class, (Throwable)exception);
                }
                return false;
            }
        }
    }

    public static abstract class TargetedPolicy
    extends Policy {
        @Override
        public Template<? extends Type> template() {
            return ((Template)((Template)((Template)super.template().type(TargetedPolicy.class)).add((Relationship)((Relationship)((Relationship)new Relationship("users").category(User.class)).summary("Users")).description("The list of users for which this policy applies explicitly. Normally a policy applies to a role, but exceptions can be added for individual users."))).add((Relationship)((Relationship)((Relationship)new Relationship("groups").category(Group.class)).summary("Groups")).description("The list of groups for which this policy applies explicitly. Normally a policy applies to a role, but exceptions can be added for individual groups of users."))).add((Relationship)((Relationship)((Relationship)new Relationship("roles").category(Role.class)).summary("Roles")).description("The list of roles for which this policy applies."));
        }

        public static abstract class Type
        extends aeonics.entity.security.Policy$Type {
            public boolean appliesTo(User.Type type) {
                if (type == null) {
                    return false;
                }
                String string = type.id();
                for (Tuples.Tuple tuple : this.relations("users")) {
                    if (tuple.a == null || !string.equals(((Entity)tuple.a).id())) continue;
                    return true;
                }
                for (Tuples.Tuple tuple : this.relations("roles")) {
                    if (tuple.a == null) continue;
                    string = ((Entity)tuple.a).id();
                    for (Tuples.Tuple tuple2 : type.relations("roles")) {
                        if (tuple2.a == null || !string.equals(((Entity)tuple2.a).id())) continue;
                        return true;
                    }
                }
                for (Tuples.Tuple tuple : this.relations("groups")) {
                    if (tuple.a == null) continue;
                    string = ((Entity)tuple.a).id();
                    for (Tuples.Tuple tuple2 : type.relations("groups")) {
                        if (tuple2.a == null || !string.equals(((Entity)tuple2.a).id())) continue;
                        return true;
                    }
                    for (Tuples.Tuple tuple2 : this.relations("roles")) {
                        if (tuple2.a == null) continue;
                        string = ((Entity)tuple2.a).id();
                        for (Tuples.Tuple tuple3 : ((Entity)tuple.a).relations("roles")) {
                            if (tuple3.a == null || !string.equals(((Entity)tuple3.a).id())) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
    }

    public static class Deny
    extends Policy {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Deny Everyone")).description("A policy that evaluates a security rule for everyone in order to deny access.");
        }

        public static class Type
        extends aeonics.entity.security.Policy$Type {
            @Override
            public boolean isAllowed(User.Type type, Data data) {
                return false;
            }

            @Override
            public boolean isDenied(User.Type type, Data data) {
                if (type == User.SYSTEM) {
                    return false;
                }
                try {
                    for (Tuples.Tuple tuple : this.relations("rule")) {
                        Rule.Type type2 = (Rule.Type)((Entity)tuple.a).cast();
                        if (type2 == null) continue;
                        return type2.test(type, data);
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Rule.class, (Throwable)exception);
                }
                return false;
            }
        }
    }

    public static class Allow
    extends Policy {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template<? extends Type> template() {
            return ((Template)super.template().summary("Allow Everyone")).description("A policy that evaluates a security rule for everyone in order to allow access.");
        }

        public static class Type
        extends aeonics.entity.security.Policy$Type {
            @Override
            public boolean isDenied(User.Type type, Data data) {
                return false;
            }

            @Override
            public boolean isAllowed(User.Type type, Data data) {
                if (type == User.SYSTEM) {
                    return true;
                }
                try {
                    Rule.Type type2 = (Rule.Type)this.firstRelation("rule");
                    if (type2 != null) {
                        return type2.test(type, data);
                    }
                }
                catch (Exception exception) {
                    Manager.of(Logger.class).warning(Rule.class, (Throwable)exception);
                }
                return false;
            }
        }
    }

    public static abstract class Type
    extends Entity {
        public abstract boolean isDenied(User.Type var1, Data var2);

        public abstract boolean isAllowed(User.Type var1, Data var2);

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Policy.class);
        }
    }
}

