/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.template.Item;
import aeonics.util.Callback;
import aeonics.util.Exportable;
import aeonics.util.StringUtils;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Registry<T extends Entity>
implements Iterable<T>,
Exportable {
    private static Map<String, Registry<? extends Entity>> registries = new ConcurrentHashMap<String, Registry<? extends Entity>>();
    private Callback<Entity, Registry<T>> onAdd = new Callback(this);
    private Callback<Entity, Registry<T>> onRemove = new Callback(this);
    private String category = null;
    private Map<String, T> entities = new ConcurrentHashMap<String, T>();

    public static <U extends Entity> Registry<U> of(Class<? extends Item<U>> clazz) {
        return Registry.of(StringUtils.toLowerCase(clazz));
    }

    public static <U extends Entity> Registry<U> of(String string2) {
        string2 = StringUtils.toLowerCase(string2);
        registries.computeIfAbsent(string2, string -> new Registry((String)string));
        return registries.get(string2);
    }

    public static boolean has(String string) {
        string = StringUtils.toLowerCase(string);
        return registries.containsKey(string);
    }

    public static <U extends Entity> U add(U u) {
        if (u == null) {
            return null;
        }
        return Registry.of(u.category()).put(u);
    }

    public static Iterable<Registry<? extends Entity>> all() {
        return Collections.unmodifiableCollection(registries.values());
    }

    public Callback<Entity, Registry<T>> onAdd() {
        return this.onAdd;
    }

    public Callback<Entity, Registry<T>> onRemove() {
        return this.onRemove;
    }

    private Registry(String string) {
        this.category = StringUtils.toLowerCase(string);
    }

    public String category() {
        return this.category;
    }

    public boolean contains(String string) {
        if (string == null || string.isBlank()) {
            return false;
        }
        if (this.entities.containsKey(string)) {
            return true;
        }
        for (Entity entity : this.entities.values()) {
            if (entity == null || !string.equalsIgnoreCase(entity.name()) && !string.equalsIgnoreCase(entity.id())) continue;
            return true;
        }
        return false;
    }

    public <U extends T> U get(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Entity entity = (Entity)this.entities.get(string);
        if (entity != null) {
            return (U)entity;
        }
        for (Entity entity2 : this.entities.values()) {
            if (entity2 == null || !string.equalsIgnoreCase(entity2.name()) && !string.equalsIgnoreCase(entity2.id())) continue;
            return (U)entity2;
        }
        return null;
    }

    public <U extends T> U get(Predicate<T> predicate) {
        if (predicate == null) {
            return null;
        }
        for (Entity entity : this.entities.values()) {
            if (entity == null || !predicate.test(entity)) continue;
            return (U)entity;
        }
        return null;
    }

    public <U extends T> U put(U u) {
        Entity entity;
        if (u == null) {
            throw new IllegalArgumentException("Cannot register a null entity");
        }
        if (!((Entity)u).category().equals(this.category())) {
            throw new IllegalArgumentException("Entity category mismatch");
        }
        if (this.entities.containsKey(((Entity)u).id()) && (entity = (Entity)this.entities.get(((Entity)u).id())) != null && entity.internal()) {
            throw new IllegalArgumentException("Cannot replace an internal entity");
        }
        this.entities.put(((Entity)u).id(), u);
        this.onAdd().trigger((Entity)u);
        return u;
    }

    public <U extends T> U remove(Entity entity) {
        if (entity != null) {
            return this.remove(entity.id());
        }
        return null;
    }

    public <U extends T> U remove(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        Entity entity = (Entity)this.entities.get(string);
        if (entity != null && !entity.internal()) {
            this.entities.remove(string, entity);
            this.onRemove().trigger(entity);
            return (U)this.closeIfCloseable(entity);
        }
        for (Entity entity2 : this.entities.values()) {
            if (entity2 == null || entity2.internal() || !string.equalsIgnoreCase(entity2.name()) && !string.equalsIgnoreCase(entity2.id())) continue;
            this.entities.remove(entity2.id(), entity2);
            this.onRemove().trigger(entity2);
            return (U)this.closeIfCloseable(entity2);
        }
        return null;
    }

    public <U extends T> U remove(Predicate<T> predicate) {
        if (predicate == null) {
            return null;
        }
        for (Entity entity : this.entities.values()) {
            if (entity == null || entity.internal() || !predicate.test(entity)) continue;
            this.entities.remove(entity.id(), entity);
            this.onRemove().trigger(entity);
            return (U)this.closeIfCloseable(entity);
        }
        return null;
    }

    public void clear() {
        this.clear(entity -> true);
    }

    public void clear(Predicate<T> predicate) {
        if (predicate == null) {
            return;
        }
        Iterator<T> iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (entity == null || entity.internal() || !predicate.test(entity)) continue;
            iterator.remove();
            this.onRemove().trigger(entity);
            this.closeIfCloseable(entity);
        }
    }

    private <U extends T> U closeIfCloseable(U u) {
        if (u instanceof Closeable) {
            try {
                ((Closeable)u).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return u;
    }

    public int size() {
        return this.entities.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.entities.values().iterator();
    }

    public Collection<T> filter(Predicate<T> predicate) {
        return this.entities.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public Data export() {
        Data data = Data.list();
        for (Entity entity : this.entities.values()) {
            data.add((Object)entity.export());
        }
        return data;
    }
}

