/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Registry;
import aeonics.manager.Manager;
import aeonics.manager.Snapshot;
import aeonics.template.Factory;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.Callback;
import aeonics.util.CheckCaller;
import aeonics.util.Exportable;
import aeonics.util.Json;
import aeonics.util.Snapshotable;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Entity
implements Exportable,
Snapshotable {
    private String id;
    private String category;
    private String type;
    private boolean internal = false;
    private String name = null;
    private Map<String, Tuples.Tuple<Data, Parameter>> parameters = new HashMap<String, Tuples.Tuple<Data, Parameter>>();
    private ThreadLocal<Data> context = null;
    private Map<String, Tuples.Tuple<List<Data>, Relationship>> relationships = new ConcurrentHashMap<String, Tuples.Tuple<List<Data>, Relationship>>();
    private Callback<Void, Entity> onRemove = new Callback(this);
    private Callback<Data, Entity> onUpdate = new Callback(this);
    private Callback<Data, Entity> onCreate = new Callback(this);
    private Snapshotable.SnapshotMode snapshotMode = Snapshotable.SnapshotMode.FULL;
    private static final Random random = new Random();

    public Entity() {
        CheckCaller.require(Template.class, "create");
    }

    public <T extends Entity> T cast() {
        return (T)this;
    }

    public final void initialize(String string, String string2, String string3, boolean bl) {
        if (this.id != null) {
            throw new IllegalStateException("Entity " + this.id() + " is already initialized");
        }
        this.category = StringUtils.toLowerCase(string);
        this.type = StringUtils.toLowerCase(string2);
        this.internal = bl;
        this.id = string3 == null || string3.isBlank() ? Entity.generateId() : string3;
    }

    public String id() {
        return this.id;
    }

    public <T extends Entity> T id(String string) {
        this.id = string;
        return (T)this;
    }

    public String category() {
        return this.category;
    }

    public String type() {
        return this.type;
    }

    public Template<Entity> template() {
        return Factory.of(this);
    }

    public boolean internal() {
        return this.internal;
    }

    public <T extends Entity> T internal(boolean bl) {
        this.internal = bl;
        return (T)this;
    }

    public String name() {
        return this.name;
    }

    public <T extends Entity> T name(String string) {
        this.name = string;
        return (T)this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Entity)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return ((Entity)object).category().equals(this.category()) && ((Entity)object).id().equals(this.id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public Map<String, Tuples.Tuple<Data, Parameter>> parameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void context(Data data) {
        if (data == null) {
            if (this.context != null) {
                this.context.remove();
            }
            return;
        }
        if (this.context == null) {
            Entity entity = this;
            synchronized (entity) {
                this.context = new ThreadLocal();
            }
        }
        this.context.set(data);
    }

    public Data context() {
        return this.context == null ? null : this.context.get();
    }

    public Data valueOf(String string) {
        return this.valueOf(string, this.context());
    }

    public Data valueOf(String string, Data data) {
        Tuples.Tuple<Data, Parameter> tuple = this.parameters().get(string);
        if (tuple == null) {
            return Data.empty();
        }
        if (((Parameter)tuple.b).format().equals("json") && ((Data)tuple.a).isString()) {
            tuple.a = Json.decode(((Data)tuple.a).asString());
        }
        if (!((Parameter)tuple.b).bindable()) {
            return (Data)tuple.a;
        }
        return ((Parameter)tuple.b).resolve((Data)tuple.a, data);
    }

    public <T extends Entity> T parameter(String string, Object object) {
        Data data = Data.of(object);
        Tuples.Tuple<Data, Parameter> tuple = this.parameters().get(string);
        if (tuple == null) {
            tuple = Tuples.Tuple.of(data, new Parameter(string));
            this.parameters().put(string, tuple);
        }
        if (!((Parameter)tuple.b).validate(data)) {
            throw new IllegalArgumentException("Parameter validation failed");
        }
        tuple.a = data;
        return (T)this;
    }

    public Set<String> relationships() {
        return Collections.unmodifiableSet(this.relationships.keySet());
    }

    public void defineRelation(Relationship relationship) {
        if (this.relationships.putIfAbsent(relationship.name(), Tuples.Tuple.of(new LinkedList(), relationship)) != null) {
            throw new IllegalArgumentException("Duplicate relationship");
        }
    }

    public void removeRelation(String string) {
        this.relationships.remove(string);
    }

    public int countRelations() {
        return this.relationships.size();
    }

    public int countRelations(String string) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            return 0;
        }
        return ((List)tuple.a).size();
    }

    public <R extends Entity> Iterable<Tuples.Tuple<R, Data>> relations(String string) {
        final Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            return Collections.emptyList();
        }
        final Iterator iterator = ((List)tuple.a).iterator();
        return () -> new Iterator<Tuples.Tuple<R, Data>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Tuples.Tuple<R, Data> next() {
                Data data = (Data)iterator.next();
                return Tuples.Tuple.of(Registry.of(((Relationship)tuple.b).category()).get(data.asString("id")), data);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public <R extends Entity> R firstRelation(String string) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            return null;
        }
        Registry registry = Registry.of(((Relationship)tuple.b).category());
        for (Data data : (List)tuple.a) {
            Object u = registry.get(data.asString("id"));
            if (u == null) continue;
            return (R)((Entity)u).cast();
        }
        return null;
    }

    public Entity addRelation(String string, Entity entity) {
        return this.addRelation(string, entity, null);
    }

    public Entity addRelation(String string, String string2) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        return this.addRelation(string, (Entity)Registry.of(StringUtils.toLowerCase(((Relationship)tuple.b).category())).get(string2), null);
    }

    public Entity addUncheckedRelation(String string, String string2, Data data) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        ((List)tuple.a).add(data.put("id", string2));
        return this;
    }

    public Entity addRelation(String string2, Entity entity, Data data) {
        if (entity == null) {
            throw new IllegalArgumentException("Invalid entity");
        }
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string2);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        if (!((Relationship)tuple.b).category().equals(entity.category())) {
            throw new IllegalArgumentException("Entity category mismatch");
        }
        if (((Relationship)tuple.b).max() > 0 && ((Relationship)tuple.b).max() <= ((List)tuple.a).size()) {
            throw new RuntimeException("Maximum number of relations reached");
        }
        Data data2 = Data.map();
        ((Relationship)tuple.b).parameters().keySet().forEach(string -> {
            if (data != null && data.containsKey((String)string)) {
                data2.put((String)string, data.get((String)string));
            }
        });
        data2.put("id", entity.id());
        for (Parameter parameter : ((Relationship)tuple.b).parameters().values()) {
            Data data3;
            if (parameter.validate(data3 = data2.get(parameter.name()))) continue;
            throw new IllegalArgumentException("Invalid value for parameter " + parameter.name());
        }
        ((List)tuple.a).add(data2);
        return this;
    }

    public boolean hasRelation(String string, Entity entity) {
        if (entity == null) {
            return false;
        }
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        for (int i = 0; i < ((List)tuple.a).size(); ++i) {
            if (!((Data)((List)tuple.a).get(i)).asString("id").equals(entity.id())) continue;
            return true;
        }
        return false;
    }

    public void removeRelation(String string, String string2) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        if (((Relationship)tuple.b).min() > 0 && ((Relationship)tuple.b).min() >= ((List)tuple.a).size()) {
            throw new RuntimeException("Minimum number of relations reached");
        }
        for (int i = 0; i < ((List)tuple.a).size(); ++i) {
            if (!((Data)((List)tuple.a).get(i)).asString("id").equals(string2)) continue;
            ((List)tuple.a).remove(i);
        }
    }

    public void removeRelation(String string, Entity entity) {
        if (entity == null) {
            return;
        }
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple == null) {
            throw new IllegalArgumentException("Invalid relationship name");
        }
        if (((Relationship)tuple.b).min() > 0 && ((Relationship)tuple.b).min() >= ((List)tuple.a).size()) {
            throw new RuntimeException("Minimum number of relations reached");
        }
        for (int i = 0; i < ((List)tuple.a).size(); ++i) {
            if (!((Data)((List)tuple.a).get(i)).asString("id").equals(entity.id())) continue;
            ((List)tuple.a).remove(i);
        }
    }

    public void clearRelation(String string) {
        Tuples.Tuple<List<Data>, Relationship> tuple = this.relationships.get(string);
        if (tuple != null) {
            ((List)tuple.a).clear();
        }
    }

    public void config(String string, Data data) {
    }

    public Callback<Void, Entity> onRemove() {
        return this.onRemove;
    }

    public Callback<Data, Entity> onUpdate() {
        return this.onUpdate;
    }

    public Callback<Data, Entity> onCreate() {
        return this.onCreate;
    }

    @Override
    public Data export() {
        Data data = Data.map().put("id", this.id()).put("name", this.name()).put("internal", this.internal()).put("readonly", this.snapshotMode() == Snapshotable.SnapshotMode.NONE).put("category", this.category()).put("type", this.type()).put("class", this.getClass().getName()).put("plugin", this.getClass().getModule().getName());
        Data data2 = Data.map();
        for (Tuples.Tuple<Data, Parameter> object : this.parameters.values()) {
            data2.put(((Parameter)object.b).name(), object.a == null ? ((Parameter)object.b).defaultValue() : object.a);
        }
        data.put("parameters", data2);
        Data data3 = Data.map();
        for (Tuples.Tuple<List<Data>, Relationship> tuple : this.relationships.values()) {
            Data data4 = Data.list();
            for (Data data5 : (List)tuple.a) {
                data4.add((Object)data5);
            }
            data3.put(((Relationship)tuple.b).name(), data4);
        }
        data.put("relationships", data3);
        return data;
    }

    @Override
    public Snapshotable.SnapshotMode snapshotMode() {
        return this.snapshotMode;
    }

    public <T extends Entity> T snapshotMode(Snapshotable.SnapshotMode snapshotMode) {
        this.snapshotMode = snapshotMode;
        return (T)this;
    }

    public <T extends Entity> T snapshotMode(String string) {
        this.snapshotMode = Snapshotable.SnapshotMode.valueOf(string);
        return (T)this;
    }

    @Override
    public Data snapshot() {
        CheckCaller.require(Manager.of(Snapshot.class).getClass(), null);
        Data data = Data.map().put("id", this.id()).put("internal", this.internal()).put("category", this.category()).put("type", this.type()).put("mode", (Object)this.snapshotMode());
        switch (this.snapshotMode()) {
            case FULL: {
                data.put("name", this.name()).put("class", this.getClass().getName()).put("plugin", this.getClass().getModule().getName());
            }
            case UPDATE: {
                Data data2 = Data.map();
                for (Tuples.Tuple<Data, Parameter> object : this.parameters.values()) {
                    data2.put(((Parameter)object.b).name(), object.a == null ? ((Parameter)object.b).defaultValue() : object.a);
                }
                data.put("parameters", data2);
                Data data3 = Data.map();
                for (Tuples.Tuple<List<Data>, Relationship> tuple : this.relationships.values()) {
                    Data data4 = Data.list();
                    for (Data data5 : (List)tuple.a) {
                        data4.add((Object)data5);
                    }
                    data3.put(((Relationship)tuple.b).name(), data4);
                }
                data.put("relationships", data3);
            }
        }
        return data;
    }

    private static String generateId() {
        int n;
        int n2 = random.nextInt() >>> 1;
        long l = System.nanoTime() >>> 1;
        StringBuilder stringBuilder = new StringBuilder("00000000-0000000000000000");
        String string = Integer.toHexString(n2);
        for (n = 0; n < string.length(); ++n) {
            stringBuilder.setCharAt(7 - n, string.charAt(string.length() - 1 - n));
        }
        string = Long.toHexString(l);
        for (n = 0; n < string.length(); ++n) {
            stringBuilder.setCharAt(9 + n, string.charAt(string.length() - 1 - n));
        }
        return stringBuilder.toString();
    }
}

