/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Message;
import aeonics.entity.Step;
import aeonics.entity.security.User;
import aeonics.template.Channel;
import aeonics.template.Template;
import aeonics.util.Snapshotable;

public class Discard {
    private static final _Discard DISCARD = (_Discard)((Entity)((Entity)((Step.Type)((Template)((Template)((Template)((Step.Template)((Step.Template)new Step.Origin(){}.target(_Discard.class).creator(() -> new _Discard()).template().cast()).icon("delete")).output((Channel)((Channel)new Channel("data").summary("Data")).description("Discarded data that has been ignored by other entities"))).summary("Discard")).description("This data origin is used as a last resort for all discarded messages. An already discarded message is ignored silently.")).create(Data.map().put("id", "10000000-1600000000000000"))).name("Discard")).internal(true)).snapshotMode(Snapshotable.SnapshotMode.UPDATE);

    private Discard() {
    }

    public static void register() {
    }

    public static void expired(Message message) {
        Discard.discard(message, Cause.EXPIRED, null);
    }

    public static void error(Message message, Throwable throwable) {
        Discard.discard(message, Cause.ERROR, throwable);
    }

    public static void ignore(Message message, String string) {
        Discard.discard(message, Cause.IGNORE, string);
    }

    public static void drop(Message message, String string) {
        Discard.discard(message, Cause.DROP, string);
    }

    public static void policy(Message message, String string) {
        Discard.discard(message, Cause.POLICY, string);
    }

    private static void discard(Message message, Cause cause, Object object) {
        if (message == null) {
            return;
        }
        message.key(cause + "/" + message.key());
        message.metadata().put("discard_user", message.user());
        message.metadata().put("discard_cause", (Object)cause);
        message.metadata().put("discard_reason", object);
        message.metadata().put("discard_topic", message.metadata().asString("topic"));
        message.user(User.SYSTEM.id());
        DISCARD.produce(message, "data");
    }

    private static final class _Discard
    extends Step.Origin.Type {
        private _Discard() {
        }

        @Override
        public void produce(Message message, String string) {
            if (message == null) {
                return;
            }
            if (!this.started()) {
                this.start();
            }
            if (message.metadata().asBool("discarded") || message.metadata().asBool("debug")) {
                return;
            }
            message.metadata().put("discarded", true);
            super.produce(message, string);
        }
    }

    public static enum Cause {
        EXPIRED,
        ERROR,
        IGNORE,
        DROP,
        POLICY;

    }
}

