/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Monitor;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Database
extends Item<Type> {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    protected Class<? extends Database> category() {
        return Database.class;
    }

    @Override
    public Template<? extends Type> template() {
        return ((Template)((Template)((Template)((Template)((Template)((Template)((Template)((Template)((Template)((Template)super.template().cast()).summary("SQL Database")).description("This entity type provides database connectivity through standard JDBC connections using an internal connection pool.")).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("size").summary("Maximum number of connections")).description("The maximum number of simultaneous connections to the database. Connections will only be established on-demand up to this limit.")).rule(Parameter.Rule.DIGIT).format("number")).optional(true).defaultValue(1))).add(((Parameter)((Parameter)((Parameter)new Parameter("jdbc").summary("JDBC connection string")).description("The JDBC connection string to the database.")).format("text")).optional(false))).add(((Parameter)((Parameter)((Parameter)new Parameter("driver").summary("Driver")).description("The full class name of the database driver.")).format("text")).optional(false))).add(((Parameter)((Parameter)((Parameter)new Parameter("username").summary("Username")).description("The username to connect to the database.")).format("text")).optional(true))).add(((Parameter)((Parameter)((Parameter)new Parameter("password").summary("Password")).description("The password to connect to the database.")).format("password")).optional(true))).onCreate((data, entity) -> {
            if (data.get("parameters").containsKey("size")) {
                ((Type)entity).refreshPoolSize();
            }
        })).onUpdate((data, entity) -> {
            if (data.get("parameters").containsKey("size")) {
                ((Type)entity).refreshPoolSize();
            }
        })).cast();
    }

    public static class Type
    extends Entity {
        private Supplier<PooledConnection> connection = () -> {
            try {
                Class.forName(this.valueOf("driver").asString());
                String string = this.valueOf("username").asString();
                String string2 = this.valueOf("password").asString();
                if (!string.isBlank() && !string2.isBlank()) {
                    return new PooledConnection(this, DriverManager.getConnection(this.valueOf("jdbc").asString(), this.valueOf("username").asString(), this.valueOf("password").asString()));
                }
                return new PooledConnection(this, DriverManager.getConnection(this.valueOf("jdbc").asString()));
            }
            catch (Exception exception) {
                Manager.of(Logger.class).info(Database.class, (Throwable)exception);
                return null;
            }
        };
        private ResizableSemaphore permits = new ResizableSemaphore(1);
        private LinkedBlockingQueue<PooledConnection> idle = new LinkedBlockingQueue();
        private LinkedBlockingQueue<PooledConnection> active = new LinkedBlockingQueue();

        public <T extends Type> T connection(Supplier<PooledConnection> supplier) {
            this.connection = supplier;
            return (T)this;
        }

        protected PooledConnection connection() {
            if (this.connection != null) {
                return this.connection.get();
            }
            return null;
        }

        public int size() {
            return this.valueOf("size").asInt();
        }

        public void refreshPoolSize() {
            int n;
            int n2 = this.size();
            if (n2 == (n = this.permits.size())) {
                return;
            }
            if (n2 > n) {
                this.permits.size = n2;
                this.permits.release(n2 - n);
            } else {
                PooledConnection pooledConnection;
                int n3;
                this.permits.size = n2;
                this.permits.reduceBy(n - n2);
                for (n3 = n - n2; n3 > 0 && !this.idle.isEmpty() && (pooledConnection = this.idle.poll()) != null; --n3) {
                    try {
                        pooledConnection.destroy();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                while (n3 > 0 && !this.active.isEmpty() && (pooledConnection = this.active.poll()) != null) {
                    --n3;
                }
            }
        }

        public PooledConnection next(long l) throws SQLException, InterruptedException {
            PooledConnection pooledConnection;
            if (l > 0L) {
                if (!this.permits.tryAcquire(l, TimeUnit.MILLISECONDS)) {
                    throw new SQLException("No database connection available within allowed timeframe");
                }
            } else {
                this.permits.acquire();
            }
            try {
                pooledConnection = this.idle.poll();
                if (pooledConnection == null) {
                    pooledConnection = this.connection();
                }
                if (pooledConnection == null) {
                    throw new SQLException("No connection available");
                }
            }
            catch (Exception exception) {
                this.permits.release();
                throw exception;
            }
            this.active.offer(pooledConnection);
            try {
                if (pooledConnection.isValid()) {
                    return pooledConnection;
                }
                this.deadConnection(pooledConnection);
                return this.next(l);
            }
            catch (Exception exception) {
                this.deadConnection(pooledConnection);
                throw exception;
            }
        }

        void returnConnection(PooledConnection pooledConnection) {
            if (this.active.remove(pooledConnection)) {
                if (pooledConnection.isValid()) {
                    this.idle.offer(pooledConnection);
                } else {
                    try {
                        pooledConnection.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.permits.release();
            } else {
                try {
                    pooledConnection.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void deadConnection(PooledConnection pooledConnection) {
            if (this.active.remove(pooledConnection)) {
                this.permits.release();
            }
            try {
                pooledConnection.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Data query(String string, Collection<Object> collection) throws SQLException {
            return this.query(-1L, string, collection.toArray());
        }

        public Data query(String string, Object ... objectArray) throws SQLException {
            return this.query(-1L, string, objectArray);
        }

        public Data query(long l, String string, Object ... objectArray) throws SQLException {
            long l2 = System.nanoTime();
            try {
                PooledConnection pooledConnection = this.next(l);
                try {
                    Data data = pooledConnection.query(string, objectArray);
                    if (pooledConnection != null) {
                        pooledConnection.close();
                    }
                    return data;
                }
                catch (Throwable throwable) {
                    try {
                        if (pooledConnection != null) {
                            try {
                                pooledConnection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw sQLException;
                    }
                    catch (Exception exception) {
                        throw new SQLException(exception);
                    }
                }
            }
            finally {
                Manager.of(Monitor.class).count(this, "time", System.nanoTime() - l2);
            }
        }

        public Data tables() throws SQLException, InterruptedException {
            try (PooledConnection pooledConnection = this.next(-1L);){
                Data data = pooledConnection.tables();
                return data;
            }
        }

        public Data columns(String string) throws SQLException, InterruptedException {
            try (PooledConnection pooledConnection = this.next(-1L);){
                Data data = pooledConnection.columns(string);
                return data;
            }
        }

        public Data schema() throws SQLException, InterruptedException {
            try (PooledConnection pooledConnection = this.next(-1L);){
                Data data = pooledConnection.tables();
                for (Data data2 : data) {
                    data2.put("columns", pooledConnection.columns(data2.asString("name")));
                }
                Data data3 = data;
                return data3;
            }
        }

        @Override
        public Data export() {
            Data data = super.export();
            data.get("parameters").remove("password");
            return data;
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Database.class);
        }

        private static class ResizableSemaphore
        extends Semaphore {
            private int size;

            public ResizableSemaphore(int n) {
                super(n);
                this.size = n;
            }

            public synchronized void reduceBy(int n) {
                if (n <= 0) {
                    return;
                }
                if (n >= this.size) {
                    n = this.size - 1;
                }
                super.reducePermits(n);
            }

            public int size() {
                return this.size;
            }
        }
    }

    public static class PooledConnection
    implements AutoCloseable {
        private Type pool;
        private Connection connection;

        public PooledConnection(Type type, Connection connection) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(connection);
            this.pool = type;
            this.connection = connection;
        }

        public void destroy() {
            this.pool = null;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = null;
            }
        }

        public boolean isValid() {
            try {
                return this.connection != null && this.connection.isValid(1);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Data query(String string, Object ... objectArray) throws SQLException {
            if (this.connection == null) {
                this.pool.deadConnection(this);
                throw new SQLException("Underlying database connection is not available");
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(string, 1);){
                Object object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] instanceof Data) {
                        preparedStatement.setObject(i + 1, ((Data)objectArray[i]).asString());
                        continue;
                    }
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
                if (preparedStatement.execute()) {
                    object = preparedStatement.getResultSet();
                    try {
                        Object object2;
                        Data data = Data.list();
                        while (object.next()) {
                            object2 = object.getMetaData();
                            Data data2 = Data.map();
                            for (int i = 1; i <= object2.getColumnCount(); ++i) {
                                data2.put(object2.getColumnLabel(i).toLowerCase(), object.getObject(i));
                            }
                            data.add((Object)data2);
                        }
                        object2 = data;
                        return object2;
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                object = preparedStatement.getGeneratedKeys();
                try {
                    if (object.next()) {
                        ResultSetMetaData resultSetMetaData = object.getMetaData();
                        int n = resultSetMetaData.getColumnCount();
                        Data data = Data.map();
                        for (int i = 1; i <= n; ++i) {
                            data.put(resultSetMetaData.getColumnLabel(i).toLowerCase(), object.getObject(i));
                        }
                        Data data3 = data;
                        return data3;
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
                object = Data.of(preparedStatement.getUpdateCount());
                return object;
            }
            catch (SQLException sQLException) {
                if (!this.connection.isValid(1)) {
                    this.pool.deadConnection(this);
                }
                Manager.of(Logger.class).finer(Database.class, (Throwable)sQLException);
                throw sQLException;
            }
        }

        @Override
        public void close() {
            if (this.pool != null) {
                this.pool.returnConnection(this);
            }
        }

        public Data tables() throws SQLException {
            try {
                ResultSet resultSet = this.connection.getMetaData().getTables(this.connection.getCatalog(), this.connection.getSchema(), "%", null);
                Data data = Data.list();
                while (resultSet.next()) {
                    data.add((Object)Data.map().put("name", resultSet.getString("TABLE_NAME")).put("schema", resultSet.getString("TABLE_SCHEM")).put("database", resultSet.getString("TABLE_CAT")));
                }
                return data;
            }
            catch (SQLException sQLException) {
                this.pool.deadConnection(this);
                throw sQLException;
            }
        }

        public Data columns(String string) throws SQLException {
            try {
                ResultSet resultSet = this.connection.getMetaData().getPrimaryKeys(this.connection.getCatalog(), this.connection.getSchema(), string);
                LinkedList<String> linkedList = new LinkedList<String>();
                while (resultSet.next()) {
                    linkedList.add(resultSet.getString("COLUMN_NAME"));
                }
                resultSet = this.connection.getMetaData().getColumns(this.connection.getCatalog(), this.connection.getSchema(), string, null);
                Data data = Data.list();
                while (resultSet.next()) {
                    data.add((Object)Data.map().put("name", resultSet.getString("COLUMN_NAME")).put("size", resultSet.getString("COLUMN_SIZE")).put("auto", resultSet.getString("IS_AUTOINCREMENT").equals("YES") || resultSet.getString("COLUMN_DEF") != null).put("null", resultSet.getString("IS_NULLABLE").equals("YES")).put("type", JDBCType.valueOf(resultSet.getInt("DATA_TYPE")).getName()).put("primary", linkedList.contains(resultSet.getString("COLUMN_NAME"))));
                }
                return data;
            }
            catch (SQLException sQLException) {
                this.pool.deadConnection(this);
                throw sQLException;
            }
        }
    }
}

