/*
 * Decompiled with CFR 0.152.
 */
package aeonics.data;

import aeonics.data.DataList;
import aeonics.data.DataMap;
import aeonics.data.DataObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Data
extends Iterable<Data> {
    public static final Pattern nestedSplitter = Pattern.compile("[\\./\\\\]");

    public static Data of(Object object) {
        if (object instanceof Data) {
            return (Data)object;
        }
        if (object instanceof Throwable) {
            return new DataObject(object);
        }
        if (object instanceof Path) {
            return new DataObject(object);
        }
        if (object instanceof byte[]) {
            return new DataObject(new String((byte[])object, StandardCharsets.ISO_8859_1));
        }
        if (object instanceof char[]) {
            return new DataObject(new String((char[])object));
        }
        if (object instanceof Map) {
            return new DataMap((Map)object);
        }
        if (object instanceof Collection) {
            return new DataList((Collection)object);
        }
        if (object instanceof Set) {
            return new DataList((Set)object);
        }
        if (object instanceof Enumeration) {
            return new DataList((Enumeration)object);
        }
        if (object instanceof Iterable) {
            return new DataList((Iterable)object);
        }
        if (object instanceof Iterator) {
            return new DataList((Iterator)object);
        }
        if (object != null && object.getClass().isArray()) {
            if (object.getClass().getComponentType().isPrimitive()) {
                return DataList.fromPrimitiveArray(object);
            }
            return new DataList((Object[])object);
        }
        return new DataObject(object);
    }

    public static Data empty() {
        return new DataObject(null);
    }

    public static Data map() {
        return new DataMap(null);
    }

    public static Data list() {
        return new DataList((Collection)null);
    }

    public static Data list(Object ... objectArray) {
        return new DataList(objectArray);
    }

    @Override
    public Iterator<Data> iterator();

    public Iterable<Map.Entry<String, Data>> entrySet();

    public boolean isMap();

    public boolean isList();

    public boolean isBool();

    public boolean isNumber();

    public boolean isString();

    public boolean isNull();

    public boolean is(Class<?> var1);

    public boolean isEmpty();

    default public boolean isMap(String string) {
        return this.isMap() && this.get(string).isMap();
    }

    default public boolean isList(String string) {
        return this.isMap() && this.get(string).isList();
    }

    default public boolean isBool(String string) {
        return this.isMap() && this.get(string).isBool();
    }

    default public boolean isNumber(String string) {
        return this.isMap() && this.get(string).isNumber();
    }

    default public boolean isString(String string) {
        return this.isMap() && this.get(string).isString();
    }

    default public boolean isNull(String string) {
        return this.isMap() && this.get(string).isNull();
    }

    default public boolean isEmpty(String string) {
        return this.isMap() && this.get(string).isEmpty();
    }

    default public boolean is(String string, Class<?> clazz) {
        return this.isMap() && this.get(string).is(clazz);
    }

    default public boolean isMap(int n) {
        return this.isList() && this.get(n).isMap();
    }

    default public boolean isList(int n) {
        return this.isList() && this.get(n).isList();
    }

    default public boolean isBool(int n) {
        return this.isList() && this.get(n).isBool();
    }

    default public boolean isNumber(int n) {
        return this.isList() && this.get(n).isNumber();
    }

    default public boolean isString(int n) {
        return this.isList() && this.get(n).isString();
    }

    default public boolean isNull(int n) {
        return this.isList() && this.get(n).isNull();
    }

    default public boolean isEmpty(int n) {
        return this.isList() && this.get(n).isEmpty();
    }

    default public boolean is(int n, Class<?> clazz) {
        return this.isList() && this.get(n).is(clazz);
    }

    public boolean asBool();

    public String asString();

    public Number asNumber();

    default public int asInt() {
        return this.asNumber().intValue();
    }

    default public long asLong() {
        return this.asNumber().longValue();
    }

    default public double asDouble() {
        return this.asNumber().doubleValue();
    }

    default public boolean asBool(String string) {
        Data data = this.get(string);
        if (data == null) {
            return false;
        }
        return data.asBool();
    }

    default public String asString(String string) {
        Data data = this.get(string);
        if (data == null) {
            return "";
        }
        return data.asString();
    }

    default public Number asNumber(String string) {
        Data data = this.get(string);
        if (data == null) {
            return 0;
        }
        return data.asNumber();
    }

    default public int asInt(String string) {
        return this.asNumber(string).intValue();
    }

    default public long asLong(String string) {
        return this.asNumber(string).longValue();
    }

    default public double asDouble(String string) {
        return this.asNumber(string).doubleValue();
    }

    default public boolean asBool(int n) {
        Data data = this.get(n);
        if (data == null) {
            return false;
        }
        return data.asBool();
    }

    default public String asString(int n) {
        Data data = this.get(n);
        if (data == null) {
            return "";
        }
        return data.asString();
    }

    default public Number asNumber(int n) {
        Data data = this.get(n);
        if (data == null) {
            return 0;
        }
        return data.asNumber();
    }

    default public int asInt(int n) {
        return this.asNumber(n).intValue();
    }

    default public long asLong(int n) {
        return this.asNumber(n).longValue();
    }

    default public double asDouble(int n) {
        return this.asNumber(n).doubleValue();
    }

    default public boolean equals(String string, Object object) {
        Data data = this.get(string);
        if (data == null) {
            return object == null;
        }
        return data.equals(object);
    }

    default public boolean equals(int n, Object object) {
        Data data = this.get(n);
        if (data == null) {
            return object == null;
        }
        return data.equals(object);
    }

    default public Stream<Data> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Data get(String var1);

    public Data get(int var1);

    public <T> T get();

    default public boolean contains(Object object) {
        if (this.isList() || this.isMap()) {
            for (Data data : this) {
                if (!data.equals(object)) continue;
                return true;
            }
            return false;
        }
        return this.equals(object);
    }

    public boolean containsKey(String var1);

    default public Data find(Predicate<Data> predicate) {
        for (Data data : this) {
            if (!predicate.test(data)) continue;
            return data;
        }
        return null;
    }

    default public <T> T getOr(T t) {
        T t2 = this.get();
        return t2 == null ? t : t2;
    }

    public void clear();

    public int size();

    default public int size(String string) {
        Data data = this.get(string);
        if (data == null) {
            return 0;
        }
        return data.size();
    }

    default public int size(int n) {
        Data data = this.get(n);
        if (data == null) {
            return 0;
        }
        return data.size();
    }

    public Data remove(String var1);

    public Data remove(int var1);

    public Data remove(Data var1);

    public void removeIf(Predicate<Data> var1);

    public Data add(Object var1);

    public Data add(Object ... var1);

    public Data put(String var1, Object var2);

    public Data set(int var1, Object var2);

    public Data set(Object var1);

    public void toString(StringBuilder var1);

    public Data clone();

    public void cloneTo(Data var1);

    default public Data getNested(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        String[] stringArray = nestedSplitter.split(string);
        Data data = this;
        for (String string2 : stringArray) {
            if (!data.containsKey(string2)) {
                return Data.empty();
            }
            data = data.get(string2);
        }
        return data;
    }

    default public boolean containsKeyNested(String string) {
        if (string == null || !this.isMap() && !this.isList()) {
            return false;
        }
        String[] stringArray = nestedSplitter.split(string);
        Data data = this;
        for (String string2 : stringArray) {
            if (!data.containsKey(string2)) {
                return false;
            }
            data = data.get(string2);
        }
        return true;
    }

    default public Data putNested(String string, Object object) {
        int n;
        if (string == null) {
            string = "";
        }
        String[] stringArray = nestedSplitter.split(string);
        Data data = this;
        for (n = 0; n < stringArray.length - 1 && data.containsKey(stringArray[n]); ++n) {
            data = data.get(stringArray[n]);
        }
        while (n < stringArray.length - 1) {
            if (!data.containsKey(stringArray[n])) {
                Data data2 = Data.map();
                data.put(stringArray[n], data2);
                data = data2;
            }
            ++n;
        }
        data.put(stringArray[n], object);
        return this;
    }

    default public Data removeNested(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        String[] stringArray = nestedSplitter.split(string);
        Data data = this;
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (!data.containsKey(stringArray[n])) {
                return null;
            }
            data = data.get(stringArray[n]);
        }
        if (data.containsKey(stringArray[n])) {
            return data.remove(stringArray[n]);
        }
        return null;
    }
}

