/*
 * Decompiled with CFR 0.152.
 */
package aeonics;

import aeonics.Boot;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class Plugin {
    private static List<Plugin> plugins = null;
    private static ModuleLayer pluginLayer = null;
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    public final String name() {
        return this.getClass().getModule().getName();
    }

    public abstract String summary();

    public abstract String description();

    protected abstract void start();

    public static void initialize() {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        String string = System.getProperty("AEONICS_PLUGIN_PATH");
        if (string == null || string.isBlank()) {
            string = System.getenv("AEONICS_PLUGIN_PATH");
        }
        if (string == null || string.isBlank()) {
            string = "plugins";
        }
        ModuleFinder moduleFinder = ModuleFinder.of(Paths.get(string, new String[0]));
        Set<String> set = moduleFinder.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toSet());
        Configuration configuration = ModuleLayer.boot().configuration().resolve(moduleFinder, ModuleFinder.of(new Path[0]), set);
        pluginLayer = ModuleLayer.boot().defineModulesWithManyLoaders(configuration, new SharedPluginClassLoader());
        plugins = ServiceLoader.load(pluginLayer, Plugin.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
        plugins.forEach(plugin -> {
            try {
                plugin.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        plugins.add(Boot.INSTANCE);
    }

    public static ModuleLayer getModuleLayer() {
        return pluginLayer;
    }

    public static List<Plugin> all() {
        return Collections.unmodifiableList(plugins);
    }

    private static class SharedPluginClassLoader
    extends ClassLoader {
        private ThreadLocal<String> itself = new ThreadLocal();

        public SharedPluginClassLoader() {
            super(Plugin.class.getClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            try {
                return super.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string.equals(this.itself.get())) {
                    throw classNotFoundException;
                }
                for (Module module : Plugin.getModuleLayer().modules()) {
                    boolean bl = false;
                    for (Plugin plugin : plugins) {
                        if (!plugin.name().equals(module.getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    try {
                        this.itself.set(string);
                        Class<?> clazz = module.getClassLoader().loadClass(string);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException2) {}
                    continue;
                    finally {
                        this.itself.remove();
                    }
                }
                throw classNotFoundException;
            }
        }
    }
}

