/*
 * Decompiled with CFR 0.152.
 */
package aeonics;

import aeonics.Plugin;
import aeonics.Protocols;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;

public class Boot
extends Plugin {
    public static final long START_TIME = System.currentTimeMillis();
    public static final long BOOT_TIME = ManagementFactory.getRuntimeMXBean().getStartTime();
    public static final String VERSION = "1.0";
    public static final Thread MAIN = Thread.currentThread();
    public static final Boot INSTANCE = new Boot();
    public static final String CREDITS = "\n\n       d8888 8888888888 .d88888b.  888b    888 8888888 .d8888b.   .d8888b.  \n      d88888 888       d88P\" \"Y88b 8888b   888   888  d88P  Y88b d88P  Y88b \n     d88P888 888       888     888 88888b  888   888  888    888 Y88b.      \n    d88P 888 8888888   888     888 888Y88b 888   888  888         \"Y888b.   \n   d88P  888 888       888     888 888 Y88b888   888  888            \"Y88b. \n  d88P   888 888       888     888 888  Y88888   888  888    888       \"888 \n d8888888888 888       Y88b. .d88P 888   Y8888   888  Y88b  d88P Y88b  d88P \nd88P     888 8888888888 \"Y88888P\"  888    Y888 8888888 \"Y8888P\"   \"Y8888P\"  \n\n";
    private static final AtomicReference<Runnable> spark = new AtomicReference<Object>(null);

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && (stringArray[0].equals("-h") || stringArray[0].equals("--help") || stringArray[0].equals("-?"))) {
            System.out.println("Aeonics version 1.0\n Usage with system properties:\n -DAEONICS_MANAGER_LOGGER_LEVEL=   The log level of the system\n -DAEONICS_PLUGIN_PATH=            The plugin folder path\n\nUsage with environment variables:\n AEONICS_MANAGER_LOGGER_LEVEL      The log level of the system\n AEONICS_PLUGIN_PATH               The plugin folder path\n\nDefaults:\n AEONICS_MANAGER_LOGGER_LEVEL:     700\n AEONICS_PLUGIN_PATH:              plugins\nOther specific properties may be required for some other plugins or managers");
            return;
        }
        INSTANCE.start();
    }

    public static void spark(Runnable runnable) {
        spark.compareAndSet(null, runnable);
    }

    @Override
    public String summary() {
        return "System boot plugin 1.0";
    }

    @Override
    public String description() {
        return "This minimal boot plugin is responsible to start the system and load the plugins.";
    }

    @Override
    protected void start() {
        PrintStream printStream = System.out;
        printStream.println(CREDITS);
        try {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
            URL.setURLStreamHandlerFactory(new Protocols());
            printStream.println("{\"date\": " + System.currentTimeMillis() + ", \"level\": 800, \"type\": \"aeonics.Boot\", \"message\": \"Aeonics 1.0 starting.\"}");
            Plugin.initialize();
            Runnable runnable = spark.get();
            if (runnable != null) {
                runnable.run();
            }
            printStream.println("{\"date\": " + System.currentTimeMillis() + ", \"level\": 800, \"type\": \"aeonics.Boot\", \"message\": \"Complete.\"}");
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
            throwable2.printStackTrace(printStream);
            System.exit(1);
        }
    }
}

